/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.Interval;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.BAMInputFormat;
import org.seqdoop.hadoop_bam.BAMTestUtil;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class TestBAMInputFormat {
    private String input;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    private void completeSetup(boolean keepPairedReadsTogether, List<Interval> intervals) {
        Configuration conf = new Configuration();
        conf.set("mapred.input.dir", "file://" + this.input);
        conf.setBoolean("hadoopbam.bam.keep-paired-reads-together", keepPairedReadsTogether);
        if (intervals != null) {
            BAMInputFormat.setIntervals((Configuration)conf, intervals);
        }
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        this.jobContext = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
    }

    @Test
    public void testNoReadsInFirstSplitBug() throws Exception {
        this.input = BAMTestUtil.writeBamFileWithLargeHeader().getAbsolutePath();
        this.completeSetup(false, null);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
    }

    @Test
    public void testDontKeepPairedReadsTogether() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.queryname).getAbsolutePath();
        this.completeSetup(false, null);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1629L, (long)split0Records.size());
        Assert.assertEquals((long)371L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
        Assert.assertTrue((boolean)lastRecordOfSplit0.getFirstOfPairFlag());
        Assert.assertTrue((boolean)firstRecordOfSplit1.getSecondOfPairFlag());
    }

    @Test
    public void testKeepPairedReadsTogether() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.queryname).getAbsolutePath();
        this.completeSetup(true, null);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1630L, (long)split0Records.size());
        Assert.assertEquals((long)370L, (long)split1Records.size());
        SAMRecord lastRecordOfSplit0 = split0Records.get(split0Records.size() - 1);
        SAMRecord firstRecordOfSplit1 = split1Records.get(0);
        Assert.assertNotEquals((Object)lastRecordOfSplit0.getReadName(), (Object)firstRecordOfSplit1.getReadName());
    }

    @Test
    public void testIntervals() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 5000, 9999));
        intervals.add(new Interval("chr21", 20000, 22999));
        this.completeSetup(false, intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        Assert.assertEquals((long)16L, (long)split0Records.size());
    }

    @Test
    public void testIntervalCoveringWholeChromosome() throws Exception {
        this.input = BAMTestUtil.writeBamFile(1000, SAMFileHeader.SortOrder.coordinate).getAbsolutePath();
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        intervals.add(new Interval("chr21", 1, 1000135));
        this.completeSetup(false, intervals);
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", 40000);
        BAMInputFormat inputFormat = new BAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        List<SAMRecord> split0Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(0));
        List<SAMRecord> split1Records = this.getSAMRecordsFromSplit(inputFormat, (InputSplit)splits.get(1));
        Assert.assertEquals((long)1629L, (long)split0Records.size());
        Assert.assertEquals((long)371L, (long)split1Records.size());
    }

    private List<SAMRecord> getSAMRecordsFromSplit(BAMInputFormat inputFormat, InputSplit split) throws Exception {
        RecordReader reader = inputFormat.createRecordReader(split, this.taskAttemptContext);
        reader.initialize(split, this.taskAttemptContext);
        ArrayList<SAMRecord> records = new ArrayList<SAMRecord>();
        while (reader.nextKeyValue()) {
            SAMRecord r = ((SAMRecordWritable)reader.getCurrentValue()).get();
            records.add(r);
        }
        return records;
    }
}

