/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.seqdoop.hadoop_bam.util.BGZFSplitGuesser;

@RunWith(value=Parameterized.class)
public class TestBGZFSplitGuesser {
    private final File file;
    private final long firstSplit;
    private final long lastSplit;

    public TestBGZFSplitGuesser(String filename, long firstSplit, long lastSplit) {
        this.file = new File("src/test/resources/" + filename);
        this.firstSplit = firstSplit;
        this.lastSplit = lastSplit;
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList({"test.vcf.bgzf.gz", 821, 821}, {"HiSeq.10000.vcf.bgzf.gz", 16688, 509222});
    }

    @Test
    public void test() throws IOException {
        long end;
        long nextStart;
        Configuration conf = new Configuration();
        Path path = new Path(this.file.toURI());
        FSDataInputStream fsDataInputStream = path.getFileSystem(conf).open(path);
        BGZFSplitGuesser bgzfSplitGuesser = new BGZFSplitGuesser(fsDataInputStream);
        LinkedList<Long> boundaries = new LinkedList<Long>();
        long start = 1L;
        while ((nextStart = bgzfSplitGuesser.guessNextBGZFBlockStart(start, end = this.file.length())) != end) {
            boundaries.add(nextStart);
            this.canReadFromBlockStart(nextStart);
            start = nextStart + 1L;
        }
        Assert.assertEquals((long)this.firstSplit, (long)((Long)boundaries.getFirst()));
        Assert.assertEquals((long)this.lastSplit, (long)((Long)boundaries.getLast()));
        Assert.assertEquals((String)"Last block start is terminator gzip block", (long)(this.file.length() - (long)BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK.length), (long)((Long)boundaries.get(boundaries.size() - 1)));
    }

    private void canReadFromBlockStart(long blockStart) throws IOException {
        BlockCompressedInputStream blockCompressedInputStream = new BlockCompressedInputStream(this.file);
        blockCompressedInputStream.setCheckCrcs(true);
        blockCompressedInputStream.seek(blockStart << 16);
        byte[] b = new byte[100];
        blockCompressedInputStream.read(b);
    }
}

