/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.CRAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;

public class TestCRAMInputFormat {
    private String input;
    private String reference;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        this.input = ClassLoader.getSystemClassLoader().getResource("test.cram").getFile();
        this.reference = ClassLoader.getSystemClassLoader().getResource("auxf.fa").toURI().toString();
        conf.set("mapred.input.dir", "file://" + this.input);
        conf.set("hadoopbam.cram.reference-source-path", this.reference);
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        this.jobContext = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
    }

    @Test
    public void testReader() throws Exception {
        int expectedCount = 0;
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(new File(URI.create(this.reference))).open(new File(this.input));
        for (SAMRecord r : samReader) {
            ++expectedCount;
        }
        AnySAMInputFormat inputFormat = new AnySAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        RecordReader reader = inputFormat.createRecordReader((InputSplit)splits.get(0), this.taskAttemptContext);
        reader.initialize((InputSplit)splits.get(0), this.taskAttemptContext);
        int actualCount = 0;
        while (reader.nextKeyValue()) {
            ++actualCount;
        }
        Assert.assertEquals((long)expectedCount, (long)actualCount);
    }

    @Test
    public void testGetSplits_SpanningContainerBoundary() throws IOException {
        this.checkSplits(1000);
    }

    @Test
    public void testGetSplits_OnContainerBoundary() throws IOException {
        this.checkSplits(83);
    }

    @Test
    public void testGetSplits_OneBeforeContainerBoundary() throws IOException {
        this.checkSplits(534);
    }

    @Test
    public void testGetSplits_OneAfterContainerBoundary() throws IOException {
        this.checkSplits(535);
    }

    private void checkSplits(int splitMaxSize) throws IOException {
        this.jobContext.getConfiguration().setInt("mapreduce.input.fileinputformat.split.maxsize", splitMaxSize);
        CRAMInputFormat inputFormat = new CRAMInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)2L, (long)splits.size());
        FileSplit split0 = (FileSplit)splits.get(0);
        FileSplit split1 = (FileSplit)splits.get(1);
        Assert.assertEquals((long)1069L, (long)split0.getStart());
        Assert.assertEquals((long)2334L, (long)split0.getLength());
        Assert.assertEquals((long)3403L, (long)split1.getStart());
        Assert.assertEquals((long)30L, (long)split1.getLength());
    }

    @Test
    public void testMapReduceJob() throws Exception {
        String line;
        Configuration conf = new Configuration();
        conf.set("hadoopbam.cram.reference-source-path", this.reference);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        Path inputPath = new Path(this.input);
        Path outputPath = fileSystem.makeQualified(new Path("target/out"));
        fileSystem.delete(outputPath, true);
        Job job = Job.getInstance((Configuration)conf);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputPath});
        job.setInputFormatClass(CRAMInputFormat.class);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(SAMRecordWritable.class);
        job.setNumReduceTasks(0);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean success = job.waitForCompletion(true);
        Assert.assertTrue((boolean)success);
        ArrayList<String> samStrings = new ArrayList<String>();
        SamReader samReader = SamReaderFactory.makeDefault().referenceSequence(new File(URI.create(this.reference))).open(new File(this.input));
        for (SAMRecord r : samReader) {
            samStrings.add(r.getSAMString().trim());
        }
        File outputFile = new File(new File(outputPath.toUri()), "part-m-00000");
        BufferedReader br = new BufferedReader(new FileReader(outputFile));
        int index = 0;
        while ((line = br.readLine()) != null) {
            String value = line.substring(line.indexOf("\t") + 1);
            Assert.assertEquals(samStrings.get(index++), (Object)value);
        }
        br.close();
    }
}

