/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.FastaInputFormat;
import org.seqdoop.hadoop_bam.ReferenceFragment;

public class TestFastaInputFormat {
    private String input;
    private TaskAttemptContext taskAttemptContext;
    private JobContext jobContext;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        this.input = ClassLoader.getSystemClassLoader().getResource("auxf.fa").getFile();
        conf.set("mapred.input.dir", "file://" + this.input);
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        this.jobContext = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
    }

    @Test
    public void testReader() throws Exception {
        FastaInputFormat inputFormat = new FastaInputFormat();
        List splits = inputFormat.getSplits(this.jobContext);
        Assert.assertEquals((long)1L, (long)splits.size());
        RecordReader reader = inputFormat.createRecordReader((InputSplit)splits.get(0), this.taskAttemptContext);
        reader.initialize((InputSplit)splits.get(0), this.taskAttemptContext);
        Assert.assertTrue((boolean)reader.nextKeyValue());
        Assert.assertEquals((Object)reader.getCurrentKey(), (Object)new Text("Sheila1"));
        ReferenceFragment fragment = (ReferenceFragment)reader.getCurrentValue();
        Assert.assertEquals((Object)fragment.getSequence(), (Object)new Text("GCTAGCTCAGAAAAAAAAAA"));
        reader.close();
    }
}

