/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.seqdoop.hadoop_bam.FormatException;
import org.seqdoop.hadoop_bam.QseqInputFormat;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class TestQseqInputFormat {
    public static final String oneQseq = "ERR020229\t10880\t1\t1\t1373\t2042\t0\t1\tTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\tBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\t1";
    public static final String twoQseq = "ERR020229\t10880\t1\t1\t1373\t2042\t0\t1\tTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\tBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\t0\nERR020229\t10883\t1\t1\t1796\t2044\t0\t2\tTGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG\tDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDDD\t1";
    public static final String illuminaQseq = "EAS139\t136\t2\t5\t1000\t12850\tATCACG\t1\tTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\tBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\t0";
    public static final String nQseq = "ERR020229\t10880\t1\t1\t1373\t2042\t0\t1\t...........................................................................................\tBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\t0";
    public static final String sangerQseq = "EAS139\t136\t2\t5\t1000\t12850\tATCACG\t1\tTTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT\t###########################################################################################\t0";
    public static final String indexWithUnknown = "EAS139\t136\t2\t5\t1000\t12850\tATC..G\t1\tTTGGATGATAGGGATTATTTGACTCGAATAT\tBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB\t0";
    private JobConf conf;
    private FileSplit split;
    private File tempQseq;
    private File tempGz;
    private Text key;
    private SequencedFragment fragment;

    @Before
    public void setup() throws IOException {
        this.tempQseq = File.createTempFile("test_qseq_input_format", "qseq");
        this.tempGz = File.createTempFile("test_qseq_input_format", ".gz");
        this.conf = new JobConf();
        this.key = new Text();
        this.fragment = new SequencedFragment();
    }

    @After
    public void tearDown() {
        this.tempQseq.delete();
        this.tempGz.delete();
        this.split = null;
    }

    private void writeToTempQseq(String s) throws IOException {
        PrintWriter qseqOut = new PrintWriter(new BufferedWriter(new FileWriter(this.tempQseq)));
        qseqOut.write(s);
        qseqOut.close();
    }

    private QseqInputFormat.QseqRecordReader createReaderForOneQseq() throws IOException {
        this.writeToTempQseq(oneQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)oneQseq.length(), null);
        return new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
    }

    @Test
    public void testReadFromStart() throws IOException {
        QseqInputFormat.QseqRecordReader reader = this.createReaderForOneQseq();
        Assert.assertEquals((long)0L, (long)reader.getPos());
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229:10880:1:1:1373:2042:1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"###########################################################################################", (Object)this.fragment.getQuality().toString());
        Assert.assertEquals((long)oneQseq.length(), (long)reader.getPos());
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testReadStartInMiddle() throws IOException {
        this.writeToTempQseq(twoQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 10L, (long)(twoQseq.length() - 10), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        Assert.assertEquals((long)(oneQseq.length() + 1), (long)reader.getPos());
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229:10883:1:1:1796:2044:2", (Object)this.key.toString());
        Assert.assertEquals((Object)"TGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG", (Object)this.fragment.getSequence().toString());
        Assert.assertEquals((Object)"%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%", (Object)this.fragment.getQuality().toString());
        Assert.assertEquals((long)twoQseq.length(), (long)reader.getPos());
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
        retval = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)retval);
    }

    @Test
    public void testSliceEndsBeforeEndOfFile() throws IOException {
        this.writeToTempQseq(twoQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, 10L, null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229:10880:1:1:1373:2042:1", (Object)this.key.toString());
        Assert.assertFalse((String)"QseqRecordReader is reading a record that starts after the end of the slice", (boolean)reader.next(this.key, this.fragment));
    }

    @Test
    public void testIlluminaMetaInfo() throws IOException {
        this.writeToTempQseq(illuminaQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)illuminaQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"EAS139", (Object)this.fragment.getInstrument());
        Assert.assertEquals((long)136L, (long)this.fragment.getRunNumber().intValue());
        Assert.assertNull((String)"flowcell id not null", (Object)this.fragment.getFlowcellId());
        Assert.assertEquals((long)2L, (long)this.fragment.getLane().intValue());
        Assert.assertEquals((long)5L, (long)this.fragment.getTile().intValue());
        Assert.assertEquals((long)1000L, (long)this.fragment.getXpos().intValue());
        Assert.assertEquals((long)12850L, (long)this.fragment.getYpos().intValue());
        Assert.assertEquals((long)1L, (long)this.fragment.getRead().intValue());
        Assert.assertEquals((Object)false, (Object)this.fragment.getFilterPassed());
        Assert.assertNull((String)"control number not null", (Object)this.fragment.getControlNumber());
        Assert.assertEquals((Object)"ATCACG", (Object)this.fragment.getIndexSequence());
    }

    @Test
    public void testNs() throws IOException {
        this.writeToTempQseq(nQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)nQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN", (Object)this.fragment.getSequence().toString());
    }

    @Test
    public void testConvertDotInIndexSequence() throws IOException {
        this.writeToTempQseq(indexWithUnknown);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)indexWithUnknown.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((Object)"ATCNNG", (Object)this.fragment.getIndexSequence());
    }

    @Test(expected=FormatException.class)
    public void testSangerQualities() throws IOException {
        this.writeToTempQseq(sangerQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)sangerQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        reader.next(this.key, this.fragment);
    }

    @Test
    public void testConfigureForSangerQualities() throws IOException {
        this.conf.set("hbam.qseq-input.base-quality-encoding", "sanger");
        this.qualityConfigTest();
    }

    @Test
    public void testGenericInputConfigureForSangerQualities() throws IOException {
        this.conf.set("hbam.input.base-quality-encoding", "sanger");
        this.qualityConfigTest();
    }

    private void qualityConfigTest() throws IOException {
        this.writeToTempQseq(sangerQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)sangerQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        Assert.assertTrue((boolean)reader.next(this.key, this.fragment));
        Assert.assertEquals((Object)"###########################################################################################", (Object)this.fragment.getQuality().toString());
    }

    @Test
    public void testProgress() throws IOException {
        this.writeToTempQseq(twoQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)twoQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        Assert.assertEquals((double)0.0, (double)reader.getProgress(), (double)0.01);
        reader.next(this.key, this.fragment);
        Assert.assertEquals((double)0.5, (double)reader.getProgress(), (double)0.01);
        reader.next(this.key, this.fragment);
        Assert.assertEquals((double)1.0, (double)reader.getProgress(), (double)0.01);
    }

    @Test
    public void testCreateKey() throws IOException {
        QseqInputFormat.QseqRecordReader reader = this.createReaderForOneQseq();
        Assert.assertTrue((boolean)(reader.createKey() instanceof Text));
    }

    @Test
    public void testCreateValue() throws IOException {
        QseqInputFormat.QseqRecordReader reader = this.createReaderForOneQseq();
        Assert.assertTrue((boolean)(reader.createValue() instanceof SequencedFragment));
    }

    @Test
    public void testClose() throws IOException {
        QseqInputFormat.QseqRecordReader reader = this.createReaderForOneQseq();
        reader.close();
    }

    @Test
    public void testMakePositionMessage() throws IOException {
        this.writeToTempQseq(twoQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 10L, (long)(twoQseq.length() - 10), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        Assert.assertNotNull((Object)reader.makePositionMessage());
    }

    @Test
    public void testGzCompressedInput() throws IOException {
        GzipCodec codec = new GzipCodec();
        PrintWriter qseqOut = new PrintWriter(new BufferedOutputStream((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(this.tempGz))));
        qseqOut.write(twoQseq);
        qseqOut.close();
        this.split = new FileSplit(new Path(this.tempGz.toURI().toString()), 0L, (long)twoQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229:10880:1:1:1373:2042:1", (Object)this.key.toString());
        Assert.assertEquals((Object)"TTGGATGATAGGGATTATTTGACTCGAATATTGGAAATAGCTGTTTATATTTTTTAAAAATGGTCTGTAACTGGTGACAGGACGCTTCGAT", (Object)this.fragment.getSequence().toString());
        retval = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)retval);
        Assert.assertEquals((Object)"ERR020229:10883:1:1:1796:2044:2", (Object)this.key.toString());
        Assert.assertEquals((Object)"TGAGCAGATGTGCTAAAGCTGCTTCTCCCCTAGGATCATTTGTACCTACCAGACTCAGGGAAAGGGGTGAGAATTGGGCCGTGGGGCAAGG", (Object)this.fragment.getSequence().toString());
    }

    @Test(expected=RuntimeException.class)
    public void testCompressedSplit() throws IOException {
        GzipCodec codec = new GzipCodec();
        PrintWriter qseqOut = new PrintWriter(new BufferedOutputStream((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(this.tempGz))));
        qseqOut.write(twoQseq);
        qseqOut.close();
        this.split = new FileSplit(new Path(this.tempGz.toURI().toString()), 10L, (long)twoQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
    }

    @Test
    public void testSkipFailedQC() throws IOException {
        this.conf.set("hbam.qseq-input.filter-failed-qc", "t");
        this.verifySkipFailedQC();
    }

    @Test
    public void testSkipFailedQCGenericConfig() throws IOException {
        this.conf.set("hbam.input.filter-failed-qc", "t");
        this.verifySkipFailedQC();
    }

    private void verifySkipFailedQC() throws IOException {
        this.writeToTempQseq(twoQseq);
        this.split = new FileSplit(new Path(this.tempQseq.toURI().toString()), 0L, (long)twoQseq.length(), null);
        QseqInputFormat.QseqRecordReader reader = new QseqInputFormat.QseqRecordReader((Configuration)this.conf, this.split);
        boolean found = reader.next(this.key, this.fragment);
        Assert.assertTrue((boolean)found);
        Assert.assertEquals((long)2L, (long)this.fragment.getRead().intValue());
        found = reader.next(this.key, this.fragment);
        Assert.assertFalse((boolean)found);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{TestQseqInputFormat.class.getName()});
    }
}

