/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.InputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;

public class TestSAMHeaderReader {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testBAMHeaderReaderNoReference() throws Exception {
        Configuration conf = new Configuration();
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("test.bam");
        SamReader samReader = SamReaderFactory.makeDefault().open(SamInputResource.of((InputStream)inputStream));
        int sequenceCount = samReader.getFileHeader().getSequenceDictionary().size();
        samReader.close();
        inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("test.bam");
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((InputStream)inputStream, (Configuration)conf);
        inputStream.close();
        Assert.assertEquals((long)samHeader.getSequenceDictionary().size(), (long)sequenceCount);
    }

    @Test
    public void testCRAMHeaderReaderWithReference() throws Exception {
        Configuration conf = new Configuration();
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("test.cram");
        URI reference = ClassLoader.getSystemClassLoader().getResource("auxf.fa").toURI();
        conf.set("hadoopbam.cram.reference-source-path", reference.toString());
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((InputStream)inputStream, (Configuration)conf);
        inputStream.close();
        Assert.assertEquals((long)samHeader.getSequenceDictionary().size(), (long)1L);
    }

    @Test
    public void testCRAMHeaderReaderNoReference() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        Configuration conf = new Configuration();
        InputStream inputStream = ClassLoader.getSystemClassLoader().getResourceAsStream("test.cram");
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((InputStream)inputStream, (Configuration)conf);
        inputStream.close();
        Assert.assertEquals((long)samHeader.getSequenceDictionary().size(), (long)1L);
    }
}

