/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.seqdoop.hadoop_bam.FormatConstants;
import org.seqdoop.hadoop_bam.FormatException;
import org.seqdoop.hadoop_bam.SequencedFragment;

public class TestSequencedFragment {
    private SequencedFragment frag;
    private SequencedFragment frag2;

    @Before
    public void setup() {
        this.frag = new SequencedFragment();
        this.frag2 = new SequencedFragment();
    }

    @Test
    public void testInitialState() {
        Assert.assertNotNull((Object)this.frag.getSequence());
        Assert.assertNotNull((Object)this.frag.getQuality());
        Assert.assertNull((Object)this.frag.getInstrument());
        Assert.assertNull((Object)this.frag.getRunNumber());
        Assert.assertNull((Object)this.frag.getFlowcellId());
        Assert.assertNull((Object)this.frag.getLane());
        Assert.assertNull((Object)this.frag.getTile());
        Assert.assertNull((Object)this.frag.getXpos());
        Assert.assertNull((Object)this.frag.getYpos());
        Assert.assertNull((Object)this.frag.getRead());
        Assert.assertNull((Object)this.frag.getFilterPassed());
        Assert.assertNull((Object)this.frag.getControlNumber());
        Assert.assertNull((Object)this.frag.getIndexSequence());
        Assert.assertNotNull((Object)this.frag.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullSequence() {
        this.frag.setSequence(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoNullQuality() {
        this.frag.setQuality(null);
    }

    @Test
    public void testEquals() {
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
        this.frag.getSequence().append("AAAA".getBytes(), 0, 4);
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsSequence() {
        this.frag.getSequence().append("AAAA".getBytes(), 0, 4);
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.getSequence().append("AAAA".getBytes(), 0, 4);
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsQuality() {
        this.frag.getQuality().append("AAAA".getBytes(), 0, 4);
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.getQuality().append("AAAA".getBytes(), 0, 4);
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsInstrument() {
        this.frag.setInstrument("instrument");
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setInstrument("instrument");
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsRunNumber() {
        this.frag.setRunNumber(Integer.valueOf(240));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setRunNumber(Integer.valueOf(240));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsFlowcellId() {
        this.frag.setFlowcellId("id");
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setFlowcellId("id");
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsLane() {
        this.frag.setLane(Integer.valueOf(2));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setLane(Integer.valueOf(2));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsTile() {
        this.frag.setTile(Integer.valueOf(1000));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setTile(Integer.valueOf(1000));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsXpos() {
        this.frag.setXpos(Integer.valueOf(1234));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setXpos(Integer.valueOf(1234));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsYpos() {
        this.frag.setYpos(Integer.valueOf(1234));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setYpos(Integer.valueOf(1234));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsRead() {
        this.frag.setRead(Integer.valueOf(2));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setRead(Integer.valueOf(2));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsFilterPassed() {
        this.frag.setFilterPassed(Boolean.valueOf(false));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setFilterPassed(Boolean.valueOf(false));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsControlNumber() {
        this.frag.setControlNumber(Integer.valueOf(314));
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setControlNumber(Integer.valueOf(314));
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    @Test
    public void testEqualsIndexSequence() {
        this.frag.setIndexSequence("ABC");
        Assert.assertFalse((boolean)this.frag.equals((Object)this.frag2));
        this.frag2.setIndexSequence("ABC");
        Assert.assertTrue((boolean)this.frag.equals((Object)this.frag2));
    }

    private static SequencedFragment cloneBySerialization(SequencedFragment original) throws IOException {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outputBuffer);
        original.write((DataOutput)dataOutput);
        dataOutput.close();
        SequencedFragment newFrag = new SequencedFragment();
        newFrag.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(outputBuffer.toByteArray())));
        return newFrag;
    }

    @Test
    public void testSerializationEmpty() throws IOException {
        Assert.assertEquals((Object)this.frag, (Object)TestSequencedFragment.cloneBySerialization(this.frag));
    }

    @Test
    public void testSerializationWithSeq() throws IOException {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("##############################"));
        Assert.assertEquals((Object)this.frag, (Object)TestSequencedFragment.cloneBySerialization(this.frag));
    }

    @Test
    public void testSerializationWithFields() throws IOException {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("BBBBBBBBBBBBBBBBBBBBBBBBBBBBBB"));
        this.frag.setInstrument("machine");
        this.frag.setLane(Integer.valueOf(3));
        this.frag.setRead(Integer.valueOf(1));
        this.frag.setIndexSequence("CAT");
        Assert.assertEquals((Object)this.frag, (Object)TestSequencedFragment.cloneBySerialization(this.frag));
    }

    @Test
    public void testToString() {
        String seq = "AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT";
        String qual = "##############################";
        this.frag.setSequence(new Text(seq));
        this.frag.setQuality(new Text(qual));
        this.frag.setInstrument("machine");
        this.frag.setRunNumber(Integer.valueOf(123));
        this.frag.setFlowcellId("flowcell");
        this.frag.setLane(Integer.valueOf(3));
        this.frag.setTile(Integer.valueOf(1001));
        this.frag.setXpos(Integer.valueOf(1234));
        this.frag.setYpos(Integer.valueOf(4321));
        this.frag.setIndexSequence("CAT");
        this.frag.setRead(Integer.valueOf(1));
        Assert.assertEquals((Object)("machine\t123\tflowcell\t3\t1001\t1234\t4321\tCAT\t1\t" + seq + "\t" + qual + "\t1"), (Object)this.frag.toString());
    }

    @Test
    public void testVerifyQualitySangerOk() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("##############################"));
        Assert.assertEquals((long)-1L, (long)SequencedFragment.verifyQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger));
    }

    @Test
    public void testVerifyQualityIlluminaOk() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz"));
        Assert.assertEquals((long)-1L, (long)SequencedFragment.verifyQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina));
    }

    @Test
    public void testVerifyQualitySangerOutOfRange() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("#############################" + Character.toString('\u007f')));
        Assert.assertEquals((long)29L, (long)SequencedFragment.verifyQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger));
        this.frag.setQuality(new Text("##### ########################"));
        Assert.assertEquals((long)5L, (long)SequencedFragment.verifyQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger));
    }

    @Test
    public void testVerifyQualityIlluminaOutOfRange() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("zzz=zzzzzzzzzzzzzzzzzzzzzzzzzz"));
        Assert.assertEquals((long)3L, (long)SequencedFragment.verifyQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina));
    }

    @Test
    public void testConvertQualityIlluminaToSanger() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz"));
        SequencedFragment.convertQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina, (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger);
        Assert.assertEquals((Object)"[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[", (Object)this.frag.getQuality().toString());
    }

    @Test
    public void testConvertQualitySangerToIllumina() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("[[[[[[[[[[[[[[[[[[[[[[[[[[[[[["));
        SequencedFragment.convertQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger, (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina);
        Assert.assertEquals((Object)"zzzzzzzzzzzzzzzzzzzzzzzzzzzzzz", (Object)this.frag.getQuality().toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConvertQualityNoop() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("[[[[[[[[[[[[[[[[[[[[[[[[[[[[[["));
        SequencedFragment.convertQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger, (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger);
    }

    @Test(expected=FormatException.class)
    public void testConvertQualityIlluminaOutOfRange() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("zzz=zzzzzzzzzzzzzzzzzzzzzzzzzz"));
        SequencedFragment.convertQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina, (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger);
    }

    @Test(expected=FormatException.class)
    public void testConvertQualitySangerUnderRange() {
        this.frag.setSequence(new Text("AGTAGTAGTAGTAGTAGTAGTAGTAGTAGT"));
        this.frag.setQuality(new Text("### ##########################"));
        SequencedFragment.convertQuality((Text)this.frag.getQuality(), (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Sanger, (FormatConstants.BaseQualityEncoding)FormatConstants.BaseQualityEncoding.Illumina);
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{TestSequencedFragment.class.getName()});
    }
}

