/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Interval;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFileReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.task.JobContextImpl;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.BGZFCodec;
import org.seqdoop.hadoop_bam.util.BGZFEnhancedGzipCodec;

@RunWith(value=Parameterized.class)
public class TestVCFInputFormat {
    private String filename;
    private NUM_SPLITS expectedSplits;
    private Interval interval;
    private VariantContextWritable writable;
    private List<RecordReader<LongWritable, VariantContextWritable>> readers;
    private TaskAttemptContext taskAttemptContext;

    public TestVCFInputFormat(String filename, NUM_SPLITS expectedSplits, Interval interval) {
        this.filename = filename;
        this.expectedSplits = expectedSplits;
        this.interval = interval;
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList({"test.vcf", NUM_SPLITS.ANY, null}, {"test.vcf.gz", NUM_SPLITS.EXACTLY_ONE, null}, {"test.vcf.bgzf.gz", NUM_SPLITS.ANY, null}, {"HiSeq.10000.vcf", NUM_SPLITS.MORE_THAN_ONE, null}, {"HiSeq.10000.vcf.gz", NUM_SPLITS.EXACTLY_ONE, null}, {"HiSeq.10000.vcf.bgzf.gz", NUM_SPLITS.MORE_THAN_ONE, null}, {"HiSeq.10000.vcf.bgzf.gz", NUM_SPLITS.EXACTLY_ONE, new Interval("chr1", 2700000, 2800000)}, {"HiSeq.10000.vcf.bgz", NUM_SPLITS.MORE_THAN_ONE, null}, {"HiSeq.10000.vcf.bgz", NUM_SPLITS.EXACTLY_ONE, new Interval("chr1", 2700000, 2800000)});
    }

    @Before
    public void setup() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, InterruptedException, NoSuchFieldException {
        Configuration conf = new Configuration();
        String input_file = ClassLoader.getSystemClassLoader().getResource(this.filename).getFile();
        conf.set("hadoopbam.vcf.trust-exts", "true");
        conf.set("mapred.input.dir", "file://" + input_file);
        conf.setStrings("io.compression.codecs", new String[]{BGZFEnhancedGzipCodec.class.getCanonicalName(), BGZFCodec.class.getCanonicalName()});
        conf.setInt("mapreduce.input.fileinputformat.split.maxsize", 102400);
        if (this.interval != null) {
            VCFInputFormat.setIntervals((Configuration)conf, (List)ImmutableList.of((Object)this.interval));
        }
        this.taskAttemptContext = new TaskAttemptContextImpl(conf, (TaskAttemptID)Mockito.mock(TaskAttemptID.class));
        JobContextImpl ctx = new JobContextImpl(conf, this.taskAttemptContext.getJobID());
        VCFInputFormat inputFormat = new VCFInputFormat(conf);
        List splits = inputFormat.getSplits((JobContext)ctx);
        switch (this.expectedSplits) {
            case EXACTLY_ONE: {
                Assert.assertEquals((String)"Should be exactly one split", (long)1L, (long)splits.size());
                break;
            }
            case MORE_THAN_ONE: {
                Assert.assertTrue((String)"Should be more than one split", (splits.size() > 1 ? 1 : 0) != 0);
                break;
            }
        }
        this.readers = new ArrayList<RecordReader<LongWritable, VariantContextWritable>>();
        for (InputSplit split : splits) {
            RecordReader reader = inputFormat.createRecordReader(split, this.taskAttemptContext);
            reader.initialize(split, this.taskAttemptContext);
            this.readers.add((RecordReader<LongWritable, VariantContextWritable>)reader);
        }
    }

    @Test
    public void countEntries() throws Exception {
        VCFFileReader vcfFileReader = new VCFFileReader(new File("src/test/resources/" + this.filename), false);
        CloseableIterator variantIterator = this.interval == null ? vcfFileReader.iterator() : vcfFileReader.query(this.interval.getContig(), this.interval.getStart(), this.interval.getEnd());
        int expectedCount = Iterators.size((Iterator)variantIterator);
        int counter = 0;
        for (RecordReader<LongWritable, VariantContextWritable> reader : this.readers) {
            while (reader.nextKeyValue()) {
                this.writable = (VariantContextWritable)reader.getCurrentValue();
                Assert.assertNotNull((Object)this.writable);
                VariantContext vc = this.writable.get();
                Assert.assertNotNull((Object)vc);
                String value = vc.toString();
                Assert.assertNotNull((Object)value);
                ++counter;
            }
        }
        Assert.assertEquals((long)expectedCount, (long)counter);
    }

    @Test
    public void testFirstSecond() throws Exception {
        if (!this.filename.startsWith("test.")) {
            return;
        }
        RecordReader<LongWritable, VariantContextWritable> reader = this.readers.get(0);
        if (!reader.nextKeyValue()) {
            throw new Exception("could not read first VariantContext");
        }
        this.writable = (VariantContextWritable)reader.getCurrentValue();
        Assert.assertNotNull((Object)this.writable);
        VariantContext vc = this.writable.get();
        Assert.assertNotNull((Object)vc);
        Assert.assertEquals((Object)"20", (Object)vc.getContig());
        Assert.assertEquals((long)14370L, (long)vc.getStart());
        Assert.assertEquals((long)14370L, (long)vc.getEnd());
        Assert.assertEquals((Object)"G", (Object)vc.getReference().getBaseString());
        Assert.assertEquals((Object)"A", (Object)vc.getAlternateAllele(0).getBaseString());
        Assert.assertTrue((String)"second VariantContext", (boolean)reader.nextKeyValue());
        this.writable = (VariantContextWritable)reader.getCurrentValue();
        Assert.assertNotNull((Object)this.writable);
        vc = this.writable.get();
        Assert.assertNotNull((Object)vc);
        Assert.assertEquals((Object)"20", (Object)vc.getContig());
        Assert.assertEquals((long)17330L, (long)vc.getStart());
        Assert.assertEquals((long)17330L, (long)vc.getEnd());
        Assert.assertEquals((Object)"T", (Object)vc.getReference().getBaseString());
        Assert.assertEquals((Object)"A", (Object)vc.getAlternateAllele(0).getBaseString());
    }

    static enum NUM_SPLITS {
        ANY,
        EXACTLY_ONE,
        MORE_THAN_ONE;

    }
}

