/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Before;
import org.junit.Test;
import org.seqdoop.hadoop_bam.util.TestVCFHeaderReader;
import org.seqdoop.hadoop_bam.util.VCFFileMerger;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;

public class TestVCFFileMerger {
    private String partsDirectory;
    private VCFHeader header;

    @Before
    public void setup() throws Exception {
        File partsDir = File.createTempFile("parts", "");
        partsDir.delete();
        partsDir.mkdir();
        Files.createFile(new File(partsDir, "_SUCCESS").toPath(), new FileAttribute[0]);
        this.partsDirectory = partsDir.toURI().toString();
        this.header = VCFHeaderReader.readHeaderFrom((SeekableStream)TestVCFHeaderReader.seekableStream("test.vcf"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmpty() throws IOException {
        File out = File.createTempFile("out", ".vcf");
        out.deleteOnExit();
        VCFFileMerger.mergeParts((String)this.partsDirectory, (String)out.toURI().toString(), (VCFHeader)this.header);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBCFNotSupported() throws IOException {
        File out = File.createTempFile("out", ".bcf");
        out.deleteOnExit();
        Path target = Paths.get(URI.create(this.partsDirectory)).resolve("part-m-00000");
        Files.copy(this.stream("test.uncompressed.bcf"), target, new CopyOption[0]);
        VCFFileMerger.mergeParts((String)this.partsDirectory, (String)out.toURI().toString(), (VCFHeader)this.header);
    }

    private InputStream stream(String resource) throws IOException {
        return ClassLoader.getSystemClassLoader().getResource(resource).openStream();
    }
}

