/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import com.google.common.io.Resources;
import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;
import org.seqdoop.hadoop_bam.util.VCFHeaderReader;

public class TestVCFHeaderReader {
    @Test
    public void testReadHeaderFromVCF() throws IOException {
        Assert.assertNotNull((Object)VCFHeaderReader.readHeaderFrom((SeekableStream)TestVCFHeaderReader.seekableStream("test.vcf")));
    }

    @Test
    public void testReadHeaderFromGzippedVCF() throws IOException {
        Assert.assertNotNull((Object)VCFHeaderReader.readHeaderFrom((SeekableStream)TestVCFHeaderReader.seekableStream("test.vcf.gz")));
    }

    @Test
    public void testReadHeaderFromBGZFVCF() throws IOException {
        Assert.assertNotNull((Object)VCFHeaderReader.readHeaderFrom((SeekableStream)TestVCFHeaderReader.seekableStream("test.vcf.bgzf.gz")));
    }

    static SeekableStream seekableStream(String resource) throws IOException {
        return new ByteArraySeekableStream(Resources.toByteArray((URL)ClassLoader.getSystemClassLoader().getResource(resource)));
    }
}

