/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.Locatable;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.seqdoop.hadoop_bam.util.MurmurHash3;

public class VCFRecordReader
extends RecordReader<LongWritable, VariantContextWritable> {
    private final LongWritable key = new LongWritable();
    private final VariantContextWritable vc = new VariantContextWritable();
    private VCFCodec codec = new VCFCodec();
    private LineRecordReader lineRecordReader = new LineRecordReader();
    private VCFHeader header;
    private final Map<String, Integer> contigDict = new HashMap<String, Integer>();
    private List<Interval> intervals;
    private OverlapDetector<Interval> overlapDetector;

    public void initialize(InputSplit spl, TaskAttemptContext ctx) throws IOException {
        AsciiLineReader reader;
        FileSplit split = (FileSplit)spl;
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(ctx.getConfiguration());
        FSDataInputStream ins = fs.open(file);
        CompressionCodec compressionCodec = new CompressionCodecFactory(ctx.getConfiguration()).getCodec(file);
        if (compressionCodec == null) {
            reader = new AsciiLineReader((InputStream)ins);
        } else {
            Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)compressionCodec);
            CompressionInputStream in = compressionCodec.createInputStream((InputStream)ins, decompressor);
            reader = new AsciiLineReader((InputStream)in);
        }
        AsciiLineReaderIterator it = new AsciiLineReaderIterator(reader);
        FeatureCodecHeader h = this.codec.readHeader((LineIterator)it);
        if (h == null || !(h.getHeaderValue() instanceof VCFHeader)) {
            throw new IOException("No VCF header found in " + file);
        }
        this.header = (VCFHeader)h.getHeaderValue();
        this.contigDict.clear();
        int i = 0;
        for (VCFContigHeaderLine contig : this.header.getContigLines()) {
            this.contigDict.put(contig.getID(), i++);
        }
        this.lineRecordReader.initialize(spl, ctx);
        this.intervals = VCFInputFormat.getIntervals(ctx.getConfiguration());
        if (this.intervals != null) {
            this.overlapDetector = new OverlapDetector(0, 0);
            this.overlapDetector.addAll(this.intervals, this.intervals);
        }
    }

    public void close() throws IOException {
        this.lineRecordReader.close();
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public LongWritable getCurrentKey() {
        return this.key;
    }

    public VariantContextWritable getCurrentValue() {
        return this.vc;
    }

    public boolean nextKeyValue() throws IOException {
        VariantContext v;
        String line;
        do {
            if (this.lineRecordReader.nextKeyValue()) continue;
            return false;
        } while ((line = this.lineRecordReader.getCurrentValue().toString()).startsWith("#") || !this.overlaps(v = this.codec.decode(line)));
        Integer chromIdx = this.contigDict.get(v.getContig());
        if (chromIdx == null) {
            chromIdx = (int)MurmurHash3.murmurhash3(v.getContig(), 0);
        }
        this.key.set((long)chromIdx.intValue() << 32 | (long)(v.getStart() - 1));
        this.vc.set(v, this.header);
        return true;
    }

    private boolean overlaps(VariantContext v) {
        if (this.intervals == null) {
            return true;
        }
        Interval interval = new Interval(v.getContig(), v.getStart(), v.getEnd());
        Set overlaps = this.overlapDetector.getOverlaps((Locatable)interval);
        return !overlaps.isEmpty();
    }
}

