/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedOutputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.util.NIOFileUtil;

public class VCFFileMerger {
    public static void mergeParts(String partDirectory, String outputFile, VCFHeader header) throws IOException {
        Path outputPath;
        String successFile = partDirectory + "/_SUCCESS";
        Path successPath = NIOFileUtil.asPath(successFile);
        if (!Files.exists(successPath, new LinkOption[0])) {
            throw new NoSuchFileException(successFile, null, "Unable to find _SUCCESS file");
        }
        Path partPath = NIOFileUtil.asPath(partDirectory);
        if (partPath.equals(outputPath = NIOFileUtil.asPath(outputFile))) {
            throw new IllegalArgumentException("Cannot merge parts into output with same path: " + partPath);
        }
        List<Path> parts = NIOFileUtil.getFilesMatching(partPath, "glob:**/part-[mr]-[0-9][0-9][0-9][0-9][0-9]*", ".tbi");
        if (parts.isEmpty()) {
            throw new IllegalArgumentException("Could not write bam file because no part files were found in " + partPath);
        }
        if (VCFFileMerger.isBCF(parts)) {
            throw new IllegalArgumentException("BCF files are not supported.");
        }
        Files.deleteIfExists(outputPath);
        try (OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);){
            boolean blockCompressed = VCFFileMerger.writeHeader(out, outputPath, parts, header);
            NIOFileUtil.mergeInto(parts, out);
            if (blockCompressed) {
                VCFFileMerger.writeTerminatorBlock(out);
            }
        }
        NIOFileUtil.deleteRecursive(partPath);
    }

    private static boolean writeHeader(OutputStream out, Path outputPath, List<Path> parts, VCFHeader header) throws IOException {
        if (header == null) {
            return false;
        }
        boolean blockCompressed = VCFFileMerger.isBlockCompressed(parts);
        boolean bgzExtension = outputPath.toString().endsWith(".bgz");
        if (blockCompressed && !bgzExtension) {
            System.err.println("WARNING: parts are block compressed, but output does not have .bgz extension: " + outputPath);
        } else if (!blockCompressed && bgzExtension) {
            System.err.println("WARNING: parts are not block compressed, but output has a .bgz extension: " + outputPath);
        }
        boolean gzipCompressed = VCFFileMerger.isGzipCompressed(parts);
        OutputStream headerOut = blockCompressed ? new BlockCompressedOutputStream(out, null) : (gzipCompressed ? new GZIPOutputStream(out) : out);
        VariantContextWriter writer = new VariantContextWriterBuilder().clearOptions().setOutputVCFStream(headerOut).build();
        writer.writeHeader(header);
        headerOut.flush();
        if (headerOut instanceof GZIPOutputStream) {
            ((GZIPOutputStream)headerOut).finish();
        }
        return blockCompressed;
    }

    private static boolean isBCF(List<Path> parts) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(parts.get(0), new OpenOption[0]));){
            boolean bl = VCFFormat.BCF.equals((Object)VCFFormat.inferFromData(in));
            return bl;
        }
    }

    private static boolean isBlockCompressed(List<Path> parts) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(parts.get(0), new OpenOption[0]));){
            boolean bl = BlockCompressedInputStream.isValidFile((InputStream)in);
            return bl;
        }
    }

    private static boolean isGzipCompressed(List<Path> parts) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(parts.get(0), new OpenOption[0]));){
            boolean bl = VCFFormat.isGzip(in);
            return bl;
        }
    }

    private static void writeTerminatorBlock(OutputStream out) throws IOException {
        out.write(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
    }
}

