/*
 * Decompiled with CFR 0.152.
 */
package sessl.omnetpp;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.combinator.Parsers;
import sessl.omnetpp.ResultElement;
import sessl.omnetpp.ResultFileParser;
import sessl.omnetpp.ResultReader$$anonfun$sessl$omnetpp$ResultReader$;
import sessl.omnetpp.ScalarDataEntry;
import sessl.omnetpp.VectorDataEntry;
import sessl.omnetpp.VectorEntry;
import sessl.omnetpp.VersionEntry;
import sessl.util.Logging;

public final class ResultReader$
implements Logging {
    public static final ResultReader$ MODULE$;
    private final String fileEndingVectorData;
    private final String fileEndingScalarData;
    private final ResultFileParser rfParser;
    private final String resultLocationAndPrefix;
    private final Logger logger;

    static {
        new ResultReader$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String fileEndingVectorData() {
        return this.fileEndingVectorData;
    }

    public String fileEndingScalarData() {
        return this.fileEndingScalarData;
    }

    private ResultFileParser rfParser() {
        return this.rfParser;
    }

    private String resultLocationAndPrefix() {
        return this.resultLocationAndPrefix;
    }

    public boolean isVectorDataAvailable(String workingDirectory, int runId) {
        return new File(this.getVectorFileName(workingDirectory, runId)).canRead();
    }

    public boolean isScalarDataAvailable(String workingDirectory, int runId) {
        return new File(this.getScalarFileName(workingDirectory, runId)).canRead();
    }

    public String getVectorFileName(String workingDirectory, int runId) {
        return this.retrieveFileName(workingDirectory, runId, this.fileEndingVectorData());
    }

    public String getScalarFileName(String workingDirectory, int runId) {
        return this.retrieveFileName(workingDirectory, runId, this.fileEndingScalarData());
    }

    public Map<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> readVectorFile(String workingDirectory, int runId) {
        return (Map)this.processFile(this.getVectorFileName(workingDirectory, runId), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> apply(String fileName, List<Product> results) {
                return ResultReader$.MODULE$.sessl$omnetpp$ResultReader$$processVectorFileResults(fileName, results);
            }
        });
    }

    public Map<String, Object> readScalarFile(String workingDirectory, int runId) {
        return (Map)this.processFile(this.getScalarFileName(workingDirectory, runId), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(String fileName, List<Product> results) {
                return ResultReader$.MODULE$.sessl$omnetpp$ResultReader$$processScalarFileResults(fileName, results);
            }
        });
    }

    private <X> X processFile(String fileName, Function2<String, List<Product>, X> resultProcessing) {
        Parsers.ParseResult<List<Product>> result = this.rfParser().parse(fileName);
        Predef$.MODULE$.require(result.successful(), (Function0)new Serializable(fileName){
            public static final long serialVersionUID = 0L;
            private final String fileName$1;

            public final String apply() {
                return new StringBuilder().append((Object)"An error occurred while parsing file '").append((Object)this.fileName$1).append((Object)"'.").toString();
            }
            {
                this.fileName$1 = fileName$1;
            }
        });
        return (X)resultProcessing.apply((Object)fileName, ((TraversableLike)result.get()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$1) {
                return x$1 instanceof ResultElement;
            }
        }));
    }

    private String retrieveFileName(String workingDirectory, int runId, String ending) {
        return new StringBuilder().append((Object)workingDirectory).append((Object)this.resultLocationAndPrefix()).append((Object)BoxesRunTime.boxToInteger((int)runId)).append((Object)BoxesRunTime.boxToCharacter((char)'.')).append((Object)ending).toString();
    }

    public Map<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> sessl$omnetpp$ResultReader$$processVectorFileResults(String fileName, List<Product> results) {
        scala.collection.mutable.Map rv = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1)new Serializable(fileName, rv){
            public static final long serialVersionUID = 0L;
            public final String fileName$2;
            private final scala.collection.mutable.Map rv$1;

            public final void apply(Product x$2) {
                Product product;
                block5: {
                    block3: {
                        block4: {
                            block2: {
                                product = x$2;
                                if (!(product instanceof VersionEntry)) break block2;
                                VersionEntry versionEntry2 = (VersionEntry)product;
                                ResultReader$.MODULE$.sessl$omnetpp$ResultReader$$checkVersion(this.fileName$2, versionEntry2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            if (!(product instanceof VectorEntry)) break block4;
                            VectorEntry vectorEntry2 = (VectorEntry)product;
                            Predef$.MODULE$.require(!this.rv$1.contains((Object)BoxesRunTime.boxToLong((long)vectorEntry2.id())), (Function0)new Serializable(this, vectorEntry2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$sessl$omnetpp$ResultReader$$processVectorFileResults$1 $outer;
                                private final VectorEntry x3$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Vector with ID ").append((Object)BoxesRunTime.boxToLong((long)this.x3$1.id())).append((Object)" is defined *twice* in file '").append((Object)this.$outer.fileName$2).append((Object)"'.").toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }
                            });
                            this.rv$1.update((Object)BoxesRunTime.boxToLong((long)vectorEntry2.id()), (Object)new Tuple2((Object)vectorEntry2, (Object)Nil$.MODULE$));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        if (!(product instanceof VectorDataEntry)) break block5;
                        VectorDataEntry vectorDataEntry2 = (VectorDataEntry)product;
                        Predef$.MODULE$.require(this.rv$1.contains((Object)BoxesRunTime.boxToLong((long)vectorDataEntry2.id())), (Function0)new Serializable(this, vectorDataEntry2){
                            public static final long serialVersionUID = 0L;
                            private final VectorDataEntry x4$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Vector with ID '").append((Object)BoxesRunTime.boxToLong((long)this.x4$1.id())).append((Object)"' has not been defined yet.").toString();
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        });
                        Tuple2 currentData = (Tuple2)this.rv$1.apply((Object)BoxesRunTime.boxToLong((long)vectorDataEntry2.id()));
                        VectorDataEntry vectorDataEntry3 = vectorDataEntry2;
                        this.rv$1.update((Object)BoxesRunTime.boxToLong((long)vectorDataEntry2.id()), (Object)new Tuple2(currentData._1(), (Object)((List)currentData._2()).$colon$colon((Object)vectorDataEntry3)));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported element in file '").append((Object)this.fileName$2).append((Object)"': ").append((Object)product).toString());
            }
            {
                this.fileName$2 = fileName$2;
                this.rv$1 = rv$1;
            }
        });
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)rv.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> apply(Tuple2<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> x) {
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Tuple2(((Tuple2)x._2())._1(), (Object)((List)((Tuple2)x._2())._2()).reverse()));
            }
        }, Map$.MODULE$.canBuildFrom()));
    }

    public Map<String, Object> sessl$omnetpp$ResultReader$$processScalarFileResults(String fileName, List<Product> results) {
        scala.collection.mutable.Map rv = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1)new Serializable(fileName, rv){
            public static final long serialVersionUID = 0L;
            private final String fileName$4;
            private final scala.collection.mutable.Map rv$2;

            public final void apply(Product x0$1) {
                Product product;
                block11: {
                    block10: {
                        BoxedUnit boxedUnit;
                        block9: {
                            product = x0$1;
                            if (!(product instanceof VersionEntry)) break block9;
                            VersionEntry versionEntry2 = (VersionEntry)product;
                            ResultReader$.MODULE$.sessl$omnetpp$ResultReader$$checkVersion(this.fileName$4, versionEntry2);
                            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                            break block10;
                        }
                        if (!(product instanceof ScalarDataEntry)) break block11;
                        ScalarDataEntry scalarDataEntry = (ScalarDataEntry)product;
                        Predef$.MODULE$.require(!this.rv$2.contains((Object)scalarDataEntry.name()), (Function0)new Serializable(this, scalarDataEntry){
                            public static final long serialVersionUID = 0L;
                            private final ScalarDataEntry x3$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Scalar with name '").append((Object)this.x3$2.name()).append((Object)"' is already set!").toString();
                            }
                            {
                                this.x3$2 = x3$2;
                            }
                        });
                        if (scalarDataEntry.value() instanceof Double) {
                            this.rv$2.update((Object)scalarDataEntry.name(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)scalarDataEntry.value())));
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (scalarDataEntry.value() instanceof Long) {
                            this.rv$2.update((Object)scalarDataEntry.name(), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)scalarDataEntry.value())));
                            boxedUnit = BoxedUnit.UNIT;
                        } else if (ResultReader$.MODULE$.logger().underlying().isWarnEnabled()) {
                            ResultReader$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Could not include non-numeric value '").append(scalarDataEntry.value()).append((Object)"' for scalar '").append((Object)scalarDataEntry.name()).append((Object)"'").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit3 = boxedUnit;
                    }
                    return;
                }
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Unsupported element in file '").append((Object)this.fileName$4).append((Object)"': ").append((Object)product).toString());
            }
            {
                this.fileName$4 = fileName$4;
                this.rv$2 = rv$2;
            }
        });
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)rv);
    }

    public void sessl$omnetpp$ResultReader$$checkVersion(String fileName, VersionEntry v) {
        Predef$.MODULE$.require(v.isSupportedVersion(), (Function0)new Serializable(fileName, v){
            public static final long serialVersionUID = 0L;
            private final String fileName$3;
            private final VersionEntry v$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Version '").append((Object)BoxesRunTime.boxToLong((long)this.v$1.version())).append((Object)"' of this format is currently not supported, use version ").append((Object)BoxesRunTime.boxToInteger((int)this.v$1.supportedVersion())).append((Object)" in file '").append((Object)this.fileName$3).append((Object)"' instead.").toString();
            }
            {
                this.fileName$3 = fileName$3;
                this.v$1 = v$1;
            }
        });
    }

    private ResultReader$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.fileEndingVectorData = "vec";
        this.fileEndingScalarData = "sca";
        this.rfParser = new ResultFileParser();
        this.resultLocationAndPrefix = "/results/General-";
    }
}

