/*
 * Decompiled with CFR 0.152.
 */
package sessl.omnetpp;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction1;
import sessl.AbstractExperiment;
import sessl.AfterSimTime;
import sessl.AfterWallClockTime;
import sessl.DisjunctiveStoppingCondition;
import sessl.FixedNumber;
import sessl.ReplicationCondition;
import sessl.StoppingCondition;
import sessl.omnetpp.OMNeTPPExecutor$;
import sessl.omnetpp.OMNeTPPResultHandler;
import sessl.util.ResultHandling;

@ScalaSignature(bytes="\u0006\u0001\u0005\rd\u0001B\u0001\u0003\u0001\u001d\u0011!\"\u0012=qKJLW.\u001a8u\u0015\t\u0019A!A\u0004p[:,G\u000f\u001d9\u000b\u0003\u0015\tQa]3tg2\u001c\u0001aE\u0002\u0001\u00111\u0001\"!\u0003\u0006\u000e\u0003\u0011I!a\u0003\u0003\u0003%\u0005\u00137\u000f\u001e:bGR,\u0005\u0010]3sS6,g\u000e\u001e\t\u0003\u001b9i\u0011AA\u0005\u0003\u001f\t\u0011AcT'OKR\u0003\u0006KU3tk2$\b*\u00198eY\u0016\u0014\b\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0004\u0016\u0001\t\u0007I\u0011\u0001\f\u0002\u0015\u0019LG.\u001a%fC\u0012,'/F\u0001\u0018!\tAR$D\u0001\u001a\u0015\tQ2$\u0001\u0003mC:<'\"\u0001\u000f\u0002\t)\fg/Y\u0005\u0003=e\u0011aa\u0015;sS:<\u0007B\u0002\u0011\u0001A\u0003%q#A\u0006gS2,\u0007*Z1eKJ\u0004\u0003b\u0002\u0012\u0001\u0001\u0004%\tAF\u0001\u0010Kb\u00048i\u001c8g\r&dWMT1nK\"9A\u0005\u0001a\u0001\n\u0003)\u0013aE3ya\u000e{gN\u001a$jY\u0016t\u0015-\\3`I\u0015\fHC\u0001\u0014-!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\u0011)f.\u001b;\t\u000f5\u001a\u0013\u0011!a\u0001/\u0005\u0019\u0001\u0010J\u0019\t\r=\u0002\u0001\u0015)\u0003\u0018\u0003A)\u0007\u0010]\"p]\u001a4\u0015\u000e\\3OC6,\u0007\u0005\u0003\u00042\u0001\u0001\u0006KAM\u0001\u0011o>\u00148.\u001b8h\t&\u0014Xm\u0019;pef\u00042aJ\u001a6\u0013\t!\u0004F\u0001\u0004PaRLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0003qm\t!![8\n\u0005i:$\u0001\u0002$jY\u0016Da\u0001\u0010\u0001!B\u0013i\u0014A\u00034jY\u0016<&/\u001b;feB\u0019qe\r \u0011\u0005Yz\u0014B\u0001!8\u0005)1\u0015\u000e\\3Xe&$XM\u001d\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u001a\u0002\u001d\u0015DXmY;uC\ndWMR5mK\"1A\t\u0001Q!\n\u0015\u000b1\"Y:tS\u001etW.\u001a8ugB\u0019aiS'\u000e\u0003\u001dS!\u0001S%\u0002\u0013%lW.\u001e;bE2,'B\u0001&)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0019\u001e\u0013A\u0001T5tiB!a*\u0016-[\u001d\ty5\u000b\u0005\u0002QQ5\t\u0011K\u0003\u0002S\r\u00051AH]8pizJ!\u0001\u0016\u0015\u0002\rA\u0013X\rZ3g\u0013\t1vKA\u0002NCBT!\u0001\u0016\u0015\u0011\u00059K\u0016B\u0001\u0010X!\t93,\u0003\u0002]Q\t\u0019\u0011I\\=\t\u000by\u0003A\u0011A0\u0002%\t\f7/[2D_:4\u0017nZ;sCRLwN\u001c\u000b\u0002M!)\u0011\r\u0001C!?\u0006\u0001b-\u001b8jg\",\u0005\u0010]3sS6,g\u000e\u001e\u0005\u0006G\u0002!\t\u0001Z\u0001\n[>$W\r\\0%KF$\"AJ3\t\u000b\u0019\u0014\u0007\u0019A4\u0002\u001d\u0015DXmY!oI:+Go^8sWB!q\u0005\u001b-Y\u0013\tI\u0007F\u0001\u0004UkBdWM\r\u0005\u0006G\u0002!\te\u001b\u000b\u0003Y>\u0004\"aJ7\n\u00059D#a\u0002(pi\"Lgn\u001a\u0005\u0006a*\u0004\r\u0001W\u0001\u000e[>$W\r\u001c'pG\u0006$\u0018n\u001c8\t\u000b\r\u0004A\u0011\t:\u0015\u00051\u001c\b\"\u00029r\u0001\u0004!\bCA;y\u001b\u00051(BA<\u001c\u0003\rqW\r^\u0005\u0003sZ\u00141!\u0016*J\u0011\u0015Y\b\u0001\"\u0001`\u0003yIg.\u001b;jC2L'0Z#ya\u0016\u0014\u0018.\\3oi\u000e{gNZ5h\r&dW\r\u0003\u0004~\u0001\u0001&IaX\u0001\u0010G\",7m[#yK\u000e,H/\u00192mK\"1q\u0010\u0001Q\u0005\n}\u000b\u0001$\u001b8ji&\fG.\u001b>f\u0007>tgMR5mK^\u0013\u0018\u000e^3s\u0011\u0019\t\u0019\u0001\u0001C\u0001?\u0006q1m\u001c8gS\u001e,(/Z'pI\u0016d\u0007BBA\u0004\u0001\u0011\u0005q,A\td_:4\u0017nZ;sKN#x\u000e\u001d9j]\u001eDq!a\u0003\u0001\t\u0003\ti!\u0001\fxe&$Xm\u0015;paBLgnZ\"p]\u0012LG/[8o)\r1\u0013q\u0002\u0005\t\u0003#\tI\u00011\u0001\u0002\u0014\u0005\t1\rE\u0002\n\u0003+I1!a\u0006\u0005\u0005E\u0019Fo\u001c9qS:<7i\u001c8eSRLwN\u001c\u0005\u0007\u00037\u0001A\u0011A0\u0002/\r|gNZ5hkJ,g)\u001b=fIZ\u000b'/[1cY\u0016\u001c\bbBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u0018oJLG/\u001a,be&\f'\r\\3EK\u001aLg.\u001b;j_:$2AJA\u0012\u0011!\t)#!\bA\u0002\u0005\u001d\u0012aB3mK6,g\u000e\u001e\t\u0006O!D\u0016\u0011\u0006\t\u0004O\u0005-\u0012bAA\u0017Q\t1\u0011I\\=SK\u001aDq!!\r\u0001\t\u0003\t\u0019$A\u000bwCJL\u0017M\u00197f-\u0006dW/Z!t'R\u0014\u0018N\\4\u0015\u0007a\u000b)\u0004\u0003\u0005\u00028\u0005=\u0002\u0019AA\u0015\u0003\u00151\u0018\r\\;f\u0011\u0019\tY\u0004\u0001C\u0001?\u0006A2m\u001c8gS\u001e,(/\u001a,be&\f'\r\\3t)>\u001c6-\u00198\t\r\u0005}\u0002\u0001\"\u0001`\u0003U\u0019wN\u001c4jOV\u0014XMU3qY&\u001c\u0017\r^5p]NDa!a\u0011\u0001\t\u0003y\u0016!E3yK\u000e,H/Z#ya\u0016\u0014\u0018.\\3oi\"A\u0011q\t\u0001!\n\u0013\tI%A\u0003xe&$X\rF\u0002'\u0003\u0017Bq!!\u0014\u0002F\u0001\u0007\u0001,A\u0004d_:$XM\u001c;\t\u0011\u0005\u001d\u0003\u0001\"\u0001\u0003\u0003#\"RAJA*\u0003/Bq!!\u0016\u0002P\u0001\u0007\u0001,A\u0002lKfDq!a\u000e\u0002P\u0001\u0007\u0001\f\u0003\u0005\u0002\\\u0001!\tAAA/\u000319(/\u001b;f\u0007>lW.\u001a8u)\r1\u0013q\f\u0005\b\u0003C\nI\u00061\u0001Y\u0003\u001d\u0019w.\\7f]R\u0004")
public class Experiment
extends AbstractExperiment
implements OMNeTPPResultHandler {
    private final String fileHeader;
    private String expConfFileName;
    private Option<File> workingDirectory;
    private Option<FileWriter> fileWriter;
    private Option<File> executableFile;
    private List<Map<String, Object>> assignments;
    private boolean sessl$util$ResultHandling$$resultsHandlingCalled;

    @Override
    public void considerResults(int runId, File workingDir) {
        OMNeTPPResultHandler.considerResults$(this, runId, workingDir);
    }

    public void resultsHandlingIsCalled() {
        ResultHandling.resultsHandlingIsCalled$((ResultHandling)this);
    }

    public void checkResultHandlingCorrectness(String methodName) {
        ResultHandling.checkResultHandlingCorrectness$((ResultHandling)this, (String)methodName);
    }

    public boolean sessl$util$ResultHandling$$resultsHandlingCalled() {
        return this.sessl$util$ResultHandling$$resultsHandlingCalled;
    }

    public void sessl$util$ResultHandling$$resultsHandlingCalled_$eq(boolean x$1) {
        this.sessl$util$ResultHandling$$resultsHandlingCalled = x$1;
    }

    public String fileHeader() {
        return this.fileHeader;
    }

    public String expConfFileName() {
        return this.expConfFileName;
    }

    public void expConfFileName_$eq(String x$1) {
        this.expConfFileName = x$1;
    }

    public void basicConfiguration() {
        this.initializeExperimentConfigFile();
        this.writeComment("Basic Experiment Setup");
        this.configureModel();
        this.configureStopping();
        this.configureReplications();
        this.writeComment("Fixed Model Variables");
        this.configureFixedVariables();
        this.writeComment("Parameter Scan Setup");
        this.configureVariablesToScan();
    }

    public void finishExperiment() {
        block0: {
            if (!this.fileWriter.isDefined()) break block0;
            ((OutputStreamWriter)this.fileWriter.get()).close();
        }
    }

    public void model_$eq(Tuple2<String, String> execAndNetwork) {
        this.executableFile = new Some((Object)new File((String)execAndNetwork._1()));
        this.modelLocation_$eq((Option)new Some(execAndNetwork._2()));
    }

    public Nothing$ model_$eq(String modelLocation) {
        throw new UnsupportedOperationException();
    }

    public Nothing$ model_$eq(URI modelLocation) {
        throw new UnsupportedOperationException();
    }

    public void initializeExperimentConfigFile() {
        this.checkExecutable();
        this.initializeConfFileWriter();
    }

    private void checkExecutable() {
        Predef$.MODULE$.require(this.executableFile.isDefined() && this.modelLocation().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Simulator executable and model need to be defined. Use model = (\"simulator/executable\" -> \"Network\")");
        File e = (File)this.executableFile.get();
        Predef$.MODULE$.require(e.exists() && e.isFile() && e.canExecute(), (Function0 & Serializable & scala.Serializable)() -> "Simulator execitable '" + ((File)$this.executableFile.get()).getAbsolutePath() + "' not found or not executable.");
    }

    private void initializeConfFileWriter() {
        this.workingDirectory = new Some((Object)new File(((File)this.executableFile.get()).getAbsolutePath()).getParentFile());
        File expConfFile = new File(((File)this.workingDirectory.get()).getAbsolutePath() + File.separator + this.expConfFileName());
        if (expConfFile.exists()) {
            Predef$.MODULE$.require(expConfFile.delete(), (Function0 & Serializable & scala.Serializable)() -> "Could not delete previous experiment configuration file: '" + expConfFile.getAbsolutePath() + "'.");
        }
        this.fileWriter = new Some((Object)new FileWriter(expConfFile, false));
        this.write(this.fileHeader());
    }

    public void configureModel() {
        this.write("network", (String)this.modelLocation().get());
    }

    public void configureStopping() {
        this.writeStoppingCondition(this.checkAndGetStoppingCondition());
    }

    public void writeStoppingCondition(StoppingCondition c) {
        StoppingCondition stoppingCondition = c;
        if (stoppingCondition instanceof AfterSimTime) {
            AfterSimTime afterSimTime = (AfterSimTime)stoppingCondition;
            this.write("sim-time-limit", afterSimTime.asMilliSecondsOrUnitless() + "ms");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (stoppingCondition instanceof AfterWallClockTime) {
            AfterWallClockTime afterWallClockTime = (AfterWallClockTime)stoppingCondition;
            this.write("cpu-time-limit", afterWallClockTime.asMilliSecondsOrUnitless() + "ms");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (stoppingCondition instanceof DisjunctiveStoppingCondition) {
            DisjunctiveStoppingCondition disjunctiveStoppingCondition = (DisjunctiveStoppingCondition)stoppingCondition;
            this.writeStoppingCondition(disjunctiveStoppingCondition.left());
            this.writeStoppingCondition(disjunctiveStoppingCondition.right());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException("Stopping criterion '" + c + "' not supported.");
        }
    }

    public void configureFixedVariables() {
        this.fixedVariables().foreach((Function1 & Serializable & scala.Serializable)element -> {
            this.writeVariableDefinition((Tuple2<String, Object>)element);
            return BoxedUnit.UNIT;
        });
    }

    public void writeVariableDefinition(Tuple2<String, Object> element) {
        this.write((String)element._1(), this.variableValueAsString(element._2()));
    }

    public String variableValueAsString(Object value) {
        String string;
        Object object = value;
        if (object instanceof String) {
            String string2 = (String)object;
            string = "\"" + string2 + "\"";
        } else {
            string = object.toString();
        }
        return string;
    }

    public void configureVariablesToScan() {
        this.assignments = this.createVariableSetups();
        Map varValuesLists = (Map)((TraversableLike)this.assignments.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(m1, m2) -> (Map)m2.map((Function1 & Serializable & scala.Serializable)x -> {
            Object object = x._2();
            return new Tuple2(x._1(), (Object)((List)m1.getOrElse(x._1(), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).$colon$colon(object));
        }, Map$.MODULE$.canBuildFrom()))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), (Object)((List)x._2()).reverse()), Map$.MODULE$.canBuildFrom());
        ((IterableLike)varValuesLists.zipWithIndex(Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)varValues -> {
            this.write((String)((Tuple2)varValues._1())._1(), "${v" + varValues._2$mcI$sp() + "= " + ((TraversableOnce)((Tuple2)varValues._1())._2()).mkString(",") + (varValues._2$mcI$sp() == 0 ? "}" : " ! v0}"));
            return BoxedUnit.UNIT;
        });
    }

    public void configureReplications() {
        ReplicationCondition replicationCondition = this.checkAndGetReplicationCondition();
        if (!(replicationCondition instanceof FixedNumber)) {
            throw new IllegalArgumentException("Only a fixed number of replications is supported.");
        }
        FixedNumber fixedNumber = (FixedNumber)replicationCondition;
        this.write("repeat", ((Object)BoxesRunTime.boxToInteger((int)fixedNumber.replications())).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void executeExperiment() {
        int numOfReps = BoxesRunTime.unboxToInt((Object)this.fixedReplications().get());
        int numOfJobs = this.assignments.length();
        package$.MODULE$.Range().apply(0, numOfJobs).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)assignmentId -> {
            package$.MODULE$.Range().apply(0, numOfReps).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)repNum -> {
                int runId = assignmentId * numOfReps + repNum;
                this.addAssignmentForRun(runId, assignmentId, ((TraversableOnce)$this.assignments.apply(assignmentId)).toList());
                OMNeTPPExecutor$.MODULE$.execute((File)$this.workingDirectory.get(), (File)$this.executableFile.get(), runId);
                this.considerResults(runId, (File)$this.workingDirectory.get());
                this.runDone(runId);
            });
            this.replicationsDone(assignmentId);
        });
        this.checkResultHandlingCorrectness("considerResults(...)");
        this.experimentDone();
    }

    private void write(String content) {
        ((Writer)this.fileWriter.get()).write(content + '\n');
        ((OutputStreamWriter)this.fileWriter.get()).flush();
    }

    public void write(String key, String value) {
        this.write(key + " = " + value);
    }

    public void writeComment(String comment) {
        this.write("\n# " + comment);
    }

    public Experiment() {
        ResultHandling.$init$((ResultHandling)this);
        OMNeTPPResultHandler.$init$(this);
        this.fileHeader = "#\n# This file was automatically generated by SESSL. Do NOT edit manually.\n#\n\n[General]";
        this.expConfFileName = "omnetpp.ini";
        this.workingDirectory = None$.MODULE$;
        this.fileWriter = None$.MODULE$;
        this.executableFile = None$.MODULE$;
        this.assignments = Nil$.MODULE$;
    }
}

