/*
 * Decompiled with CFR 0.152.
 */
package sessl.omnetpp;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.parsing.combinator.Parsers;
import sessl.omnetpp.ResultElement;
import sessl.omnetpp.ResultFileParser;
import sessl.omnetpp.ScalarDataEntry;
import sessl.omnetpp.VectorDataEntry;
import sessl.omnetpp.VectorEntry;
import sessl.omnetpp.VersionEntry;
import sessl.util.Logging;

public final class ResultReader$
implements Logging {
    public static ResultReader$ MODULE$;
    private final String fileEndingVectorData;
    private final String fileEndingScalarData;
    private final ResultFileParser rfParser;
    private final String resultLocationAndPrefix;
    private final Logger logger;

    static {
        new ResultReader$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String fileEndingVectorData() {
        return this.fileEndingVectorData;
    }

    public String fileEndingScalarData() {
        return this.fileEndingScalarData;
    }

    private ResultFileParser rfParser() {
        return this.rfParser;
    }

    private String resultLocationAndPrefix() {
        return this.resultLocationAndPrefix;
    }

    public boolean isVectorDataAvailable(String workingDirectory, int runId) {
        return new File(this.getVectorFileName(workingDirectory, runId)).canRead();
    }

    public boolean isScalarDataAvailable(String workingDirectory, int runId) {
        return new File(this.getScalarFileName(workingDirectory, runId)).canRead();
    }

    public String getVectorFileName(String workingDirectory, int runId) {
        return this.retrieveFileName(workingDirectory, runId, this.fileEndingVectorData());
    }

    public String getScalarFileName(String workingDirectory, int runId) {
        return this.retrieveFileName(workingDirectory, runId, this.fileEndingScalarData());
    }

    public Map<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> readVectorFile(String workingDirectory, int runId) {
        return (Map)this.processFile(this.getVectorFileName(workingDirectory, runId), (Function2 & Serializable & scala.Serializable)(fileName, results) -> MODULE$.processVectorFileResults((String)fileName, (List<Product>)results));
    }

    public Map<String, Object> readScalarFile(String workingDirectory, int runId) {
        return (Map)this.processFile(this.getScalarFileName(workingDirectory, runId), (Function2 & Serializable & scala.Serializable)(fileName, results) -> MODULE$.processScalarFileResults((String)fileName, (List<Product>)results));
    }

    private <X> X processFile(String fileName, Function2<String, List<Product>, X> resultProcessing) {
        Parsers.ParseResult<List<Object>> result = this.rfParser().parse(fileName);
        Predef$.MODULE$.require(result.successful(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("An error occurred while parsing file '").append(fileName).append("'.").toString());
        return (X)resultProcessing.apply((Object)fileName, ((TraversableLike)result.get()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResultReader$.$anonfun$processFile$2(x$1))));
    }

    private String retrieveFileName(String workingDirectory, int runId, String ending) {
        return new StringBuilder(0).append(workingDirectory).append(this.resultLocationAndPrefix()).append(runId).append('.').append(ending).toString();
    }

    private Map<Object, Tuple2<VectorEntry, List<VectorDataEntry>>> processVectorFileResults(String fileName, List<Product> results) {
        scala.collection.mutable.Map rv = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            ResultReader$.$anonfun$processVectorFileResults$1(fileName, rv, x$2);
            return BoxedUnit.UNIT;
        });
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)rv.map((Function1 & Serializable & scala.Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToLong((long)x._1$mcJ$sp()), (Object)new Tuple2(((Tuple2)x._2())._1(), (Object)((List)((Tuple2)x._2())._2()).reverse())), Map$.MODULE$.canBuildFrom()));
    }

    private Map<String, Object> processScalarFileResults(String fileName, List<Product> results) {
        scala.collection.mutable.Map rv = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        results.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResultReader$.$anonfun$processScalarFileResults$1(fileName, rv, x0$1);
            return BoxedUnit.UNIT;
        });
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)rv);
    }

    private void checkVersion(String fileName, VersionEntry v) {
        Predef$.MODULE$.require(v.isSupportedVersion(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(86).append("Version '").append(v.version()).append("' of this format is currently not supported, use version ").append(v.supportedVersion()).append(" in file '").append(fileName).append("' instead.").toString());
    }

    public static final /* synthetic */ boolean $anonfun$processFile$2(Object x$1) {
        return x$1 instanceof ResultElement;
    }

    public static final /* synthetic */ void $anonfun$processVectorFileResults$1(String fileName$2, scala.collection.mutable.Map rv$1, Product x$2) {
        Product product = x$2;
        if (product instanceof VersionEntry) {
            VersionEntry versionEntry = (VersionEntry)product;
            MODULE$.checkVersion(fileName$2, versionEntry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (product instanceof VectorEntry) {
            VectorEntry vectorEntry = (VectorEntry)product;
            Predef$.MODULE$.require(!rv$1.contains((Object)BoxesRunTime.boxToLong((long)vectorEntry.id())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Vector with ID ").append(vectorEntry.id()).append(" is defined *twice* in file '").append(fileName$2).append("'.").toString());
            rv$1.update((Object)BoxesRunTime.boxToLong((long)vectorEntry.id()), (Object)new Tuple2((Object)vectorEntry, (Object)Nil$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (product instanceof VectorDataEntry) {
            VectorDataEntry vectorDataEntry = (VectorDataEntry)product;
            Predef$.MODULE$.require(rv$1.contains((Object)BoxesRunTime.boxToLong((long)vectorDataEntry.id())), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Vector with ID '").append(vectorDataEntry.id()).append("' has not been defined yet.").toString());
            Tuple2 currentData = (Tuple2)rv$1.apply((Object)BoxesRunTime.boxToLong((long)vectorDataEntry.id()));
            VectorDataEntry vectorDataEntry2 = vectorDataEntry;
            rv$1.update((Object)BoxesRunTime.boxToLong((long)vectorDataEntry.id()), (Object)new Tuple2(currentData._1(), (Object)((List)currentData._2()).$colon$colon((Object)vectorDataEntry2)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported element in file '").append(fileName$2).append("': ").append(product).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$processScalarFileResults$1(String fileName$4, scala.collection.mutable.Map rv$2, Product x0$1) {
        Product product = x0$1;
        if (product instanceof VersionEntry) {
            VersionEntry versionEntry = (VersionEntry)product;
            MODULE$.checkVersion(fileName$4, versionEntry);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (product instanceof ScalarDataEntry) {
            BoxedUnit boxedUnit;
            ScalarDataEntry scalarDataEntry = (ScalarDataEntry)product;
            Predef$.MODULE$.require(!rv$2.contains((Object)scalarDataEntry.name()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Scalar with name '").append(scalarDataEntry.name()).append("' is already set!").toString());
            if (scalarDataEntry.value() instanceof Double) {
                rv$2.update((Object)scalarDataEntry.name(), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)scalarDataEntry.value())));
                boxedUnit = BoxedUnit.UNIT;
            } else if (scalarDataEntry.value() instanceof Long) {
                rv$2.update((Object)scalarDataEntry.name(), (Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)scalarDataEntry.value())));
                boxedUnit = BoxedUnit.UNIT;
            } else if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn(new StringBuilder(52).append("Could not include non-numeric value '").append(scalarDataEntry.value()).append("' for scalar '").append(scalarDataEntry.name()).append("'").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            throw new IllegalArgumentException(new StringBuilder(32).append("Unsupported element in file '").append(fileName$4).append("': ").append(product).toString());
        }
    }

    private ResultReader$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.fileEndingVectorData = "vec";
        this.fileEndingScalarData = "sca";
        this.rfParser = new ResultFileParser();
        this.resultLocationAndPrefix = "/results/General-";
    }
}

