/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.rr;

import lombok.NonNull;
import org.shaneking.ling.rr.RespException;
import org.shaneking.ling.zero.lang.String0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resp<D> {
    private static final Logger log = LoggerFactory.getLogger(Resp.class);
    public static final String CODE_UNKNOWN_EXCEPTION = "-1";
    public static final String CODE_SUCCESSFULLY = "0";
    private String code;
    private D data;
    private String mesg;

    public static <D> Resp<D> build(String code, D data, String mesg) {
        return new Resp<D>().setCode(code).setData(data).setMesg(mesg);
    }

    public static <D> Resp<D> failed(String code, String mesg, D data) {
        return Resp.build(code, data, mesg);
    }

    public static <D> Resp<D> failed(String code, String mesg) {
        return Resp.failed(code, mesg, null);
    }

    public static <D> Resp<D> failed(String code) {
        return Resp.failed(code, null);
    }

    public static <D> Resp<D> failed() {
        return Resp.failed(CODE_UNKNOWN_EXCEPTION);
    }

    public static <D> Resp<D> success(D data) {
        return Resp.build(CODE_SUCCESSFULLY, data, null);
    }

    public Resp<D> parseExp(@NonNull Exception exp) {
        Resp resp;
        if (exp == null) {
            throw new NullPointerException("exp is marked non-null but is null");
        }
        String code = exp.getClass().getName();
        String mesg = String0.null2EmptyTo((String)exp.getMessage(), (String)exp.toString());
        if (exp instanceof RespException && (resp = ((RespException)((Object)exp)).getResp()) != null) {
            if (!CODE_UNKNOWN_EXCEPTION.equals(resp.getCode()) && !CODE_SUCCESSFULLY.equals(resp.getCode())) {
                code = resp.getCode();
            }
            mesg = String0.null2EmptyTo((String)resp.getMesg(), (String)mesg);
        }
        if (CODE_UNKNOWN_EXCEPTION.equals(this.getCode()) || CODE_SUCCESSFULLY.equals(this.getCode())) {
            this.setCode(code);
        }
        return this.setMesg(String0.null2EmptyTo((String)this.getMesg(), (String)mesg));
    }

    public String toString() {
        return "Resp(code=" + this.getCode() + ", data=" + this.getData() + ", mesg=" + this.getMesg() + ")";
    }

    public String getCode() {
        return this.code;
    }

    public Resp<D> setCode(String code) {
        this.code = code;
        return this;
    }

    public D getData() {
        return this.data;
    }

    public Resp<D> setData(D data) {
        this.data = data;
        return this;
    }

    public String getMesg() {
        return this.mesg;
    }

    public Resp<D> setMesg(String mesg) {
        this.mesg = mesg;
        return this;
    }
}

