/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.rr;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.NonNull;
import org.shaneking.ling.rr.RbkRespException;
import org.shaneking.ling.rr.RespException;
import org.shaneking.ling.zero.lang.Boolean0;
import org.shaneking.ling.zero.lang.String0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resp<D> {
    private static final Logger log = LoggerFactory.getLogger(Resp.class);
    public static final String CODE_UNKNOWN_EXCEPTION = "-1";
    public static final String CODE_SUCCESSFULLY = "0";
    private String code;
    private D data;
    private String msg;
    @Schema(hidden=true)
    private Boolean rbk;

    public static <D> Resp<D> build(String code, D data, String msg) {
        return new Resp<D>().setCode(code).setData(data).setMsg(msg);
    }

    public static <D> Resp<D> failed(String code, String msg, D data) {
        return Resp.build(code, data, msg);
    }

    public static <D> Resp<D> failed(String code, String msg) {
        return Resp.failed(code, msg, null);
    }

    public static <D> Resp<D> failed(String code) {
        return Resp.failed(code, null);
    }

    public static <D> Resp<D> failed() {
        return Resp.failed(CODE_UNKNOWN_EXCEPTION);
    }

    public static <D> Resp<D> success(D data) {
        return Resp.build(CODE_SUCCESSFULLY, data, null);
    }

    public Resp<D> attach(Boolean rbk) {
        this.rbk = rbk;
        return this;
    }

    public Boolean detach() {
        Boolean rtn = this.rbk;
        this.rbk = null;
        return rtn;
    }

    public Resp<D> parseExp(@NonNull Exception exp) {
        if (exp == null) {
            throw new NullPointerException("exp is marked non-null but is null");
        }
        String code = exp.getClass().getName();
        String message = String0.null2EmptyTo((String)exp.getMessage(), (String)exp.toString());
        if (exp instanceof RespException) {
            Resp resp;
            if (exp instanceof RbkRespException) {
                this.rbk = true;
            }
            if ((resp = ((RespException)((Object)exp)).getResp()) != null) {
                this.setRbk(Boolean0.nullToFalse((Boolean)this.getRbk()) || Boolean0.nullToFalse((Boolean)resp.getRbk()));
                if (!CODE_UNKNOWN_EXCEPTION.equals(resp.getCode()) && !CODE_SUCCESSFULLY.equals(resp.getCode())) {
                    code = resp.getCode();
                }
                message = String0.null2EmptyTo((String)resp.getMsg(), (String)message);
            }
        }
        if (CODE_UNKNOWN_EXCEPTION.equals(this.getCode()) || CODE_SUCCESSFULLY.equals(this.getCode())) {
            this.setCode(code);
        }
        return this.setMsg(String0.null2EmptyTo((String)this.getMsg(), (String)message));
    }

    public String toString() {
        return "Resp(code=" + this.getCode() + ", data=" + this.getData() + ", msg=" + this.getMsg() + ", rbk=" + this.getRbk() + ")";
    }

    public String getCode() {
        return this.code;
    }

    public Resp<D> setCode(String code) {
        this.code = code;
        return this;
    }

    public D getData() {
        return this.data;
    }

    public Resp<D> setData(D data) {
        this.data = data;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public Resp<D> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Boolean getRbk() {
        return this.rbk;
    }

    public Resp<D> setRbk(Boolean rbk) {
        this.rbk = rbk;
        return this;
    }
}

