/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.rr;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.NonNull;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.RbkRespException;
import org.shaneking.ling.rr.Req;
import org.shaneking.ling.rr.RespException;
import org.shaneking.ling.rr.RespMsg;
import org.shaneking.ling.rr.RespMsgBody;
import org.shaneking.ling.zero.lang.Boolean0;
import org.shaneking.ling.zero.lang.String0;

public class Resp<O, I> {
    public static final String CODE_UNKNOWN_EXCEPTION = "-1";
    public static final String CODE_SUCCESSFULLY = "0";
    public static final String CODE_PARTIAL_SUCCESS = "1";
    private String mvc;
    private String enc;
    private RespMsg<O> msg;
    @Schema(hidden=true)
    private Boolean rbk;
    @Schema(hidden=true)
    private I req;

    public static <O, I> Resp<O, I> build() {
        return new Resp<O, I>();
    }

    public static <O, I> Resp<O, I> build(I req, String code, O data, String info) {
        Resp<O, I> rtn = new Resp<O, I>().setReq(req).setMsg(RespMsg.build().setBody(RespMsgBody.build(code, data, info)));
        if (req instanceof Req) {
            rtn.gnnMsg().setRno(((Req)req).gnnMsg().gnnRno()).setAno(((Req)req).gnnMsg().gnnAno());
        }
        return rtn;
    }

    public static <O, I> Resp<O, I> failed(I req, String code, String info, O data) {
        return Resp.build(req, code, data, info);
    }

    public static <O, I> Resp<O, I> failed(I req, String code, String info) {
        return Resp.failed(req, code, info, null);
    }

    public static <O, I> Resp<O, I> failed(I req, String code) {
        return Resp.failed(req, code, null);
    }

    public static <O, I> Resp<O, I> failed(I req) {
        return Resp.failed(req, CODE_UNKNOWN_EXCEPTION);
    }

    public static <O, I> Resp<O, I> failed() {
        return Resp.failed(null);
    }

    public static <O, I> Resp<O, I> success(I req, O data) {
        return Resp.build(req, CODE_SUCCESSFULLY, data, null);
    }

    public static <O, I> Resp<O, I> success(O data) {
        return Resp.success(null, data);
    }

    public Resp<O, I> parseExp(@NonNull Exception exp) {
        if (exp == null) {
            throw new NullPointerException("exp is marked non-null but is null");
        }
        String code = exp.getClass().getName();
        String info = String0.null2EmptyTo((String)exp.getMessage(), (String)exp.toString());
        if (exp instanceof RespException) {
            Resp resp;
            if (exp instanceof RbkRespException) {
                this.setRbk(true);
            }
            if ((resp = ((RespException)((Object)exp)).getResp()) != null) {
                this.setRbk(Boolean0.nullToFalse((Boolean)this.getRbk()) || Boolean0.nullToFalse((Boolean)resp.getRbk()));
                if (!CODE_UNKNOWN_EXCEPTION.equals(resp.gnaMsgBodyCode()) && !CODE_SUCCESSFULLY.equals(resp.gnaMsgBodyCode())) {
                    code = String0.null2EmptyTo((String)resp.gnaMsgBodyCode(), (String)code);
                }
                info = String0.null2EmptyTo((String)resp.gnaMsgBodyInfo(), (String)info);
            }
        }
        if (CODE_UNKNOWN_EXCEPTION.equals(this.gnaMsgBodyCode()) || CODE_SUCCESSFULLY.equals(this.gnaMsgBodyCode())) {
            this.gnnMsg().gnnBody().setCode(code);
        }
        this.gnnMsg().gnnBody().setInfo(String0.null2EmptyTo((String)this.gnaMsgBodyInfo(), (String)info));
        return this;
    }

    public String gnaMsgBodyCode() {
        return this.gnnMsg().gnnBody().getCode();
    }

    public String gnaMsgBodyInfo() {
        return this.gnnMsg().gnnBody().getInfo();
    }

    public O gnaMsgBodyData() {
        return this.gnnMsg().gnnBody().getData();
    }

    public RespMsg<O> gnnMsg() {
        if (this.getMsg() == null) {
            this.setMsg(RespMsg.build());
        }
        return this.getMsg();
    }

    public Resp<O, I> srtMsgBody(RespMsgBody<O> respMsgBody) {
        this.gnnMsg().setBody(respMsgBody);
        return this;
    }

    public Resp<O, I> srtMsgBodyData(O o) {
        this.gnnMsg().gnnBody().setData(o);
        return this;
    }

    public Resp<O, I> srtMsgBodyCode(String code) {
        this.gnnMsg().gnnBody().setCode(code);
        return this;
    }

    public Resp<O, I> srtMsgBodyInfo(String info) {
        this.gnnMsg().gnnBody().setInfo(info);
        return this;
    }

    public String jsonStr() {
        I req = this.getReq();
        String rtn = OM3.writeValueAsString(this.setReq(null));
        this.setReq(req);
        return rtn;
    }

    public String toString() {
        return "Resp(mvc=" + this.getMvc() + ", enc=" + this.getEnc() + ", msg=" + this.getMsg() + ", rbk=" + this.getRbk() + ", req=" + this.getReq() + ")";
    }

    public String getMvc() {
        return this.mvc;
    }

    public Resp<O, I> setMvc(String mvc) {
        this.mvc = mvc;
        return this;
    }

    public String getEnc() {
        return this.enc;
    }

    public Resp<O, I> setEnc(String enc) {
        this.enc = enc;
        return this;
    }

    public RespMsg<O> getMsg() {
        return this.msg;
    }

    public Resp<O, I> setMsg(RespMsg<O> msg) {
        this.msg = msg;
        return this;
    }

    public Boolean getRbk() {
        return this.rbk;
    }

    public Resp<O, I> setRbk(Boolean rbk) {
        this.rbk = rbk;
        return this;
    }

    public I getReq() {
        return this.req;
    }

    public Resp<O, I> setReq(I req) {
        this.req = req;
        return this;
    }
}

