/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.test;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.shaneking.ling.zero.io.File0;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.time.Stopwatch0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SKUnit {
    private static final Logger log = LoggerFactory.getLogger(SKUnit.class);
    public static final File MAVEN_TEST_ROOT_FOLDER = new File("src/test/java");
    private String tstFiles = "tstFiles";
    private String tstI = String0.I.toLowerCase();
    private String tstO = String0.O.toLowerCase();
    private String tstSeq = null;
    private Stopwatch0 stopwatch;
    private TestInfo tstInfo;

    @AfterEach
    public void tstAfter() {
        log.info(((Method)this.getTstInfo().getTestMethod().get()).getName() + String0.EQUAL + this.getStopwatch().stop());
    }

    @BeforeEach
    public void tstBefore(TestInfo testInfo) {
        this.setTstInfo(testInfo);
        this.setStopwatch(Stopwatch0.createStarted());
    }

    public File tstFiles(String io, String fileType) {
        File rtn = new File(this.tstFolder(), ((Class)this.getTstInfo().getTestClass().get()).getSimpleName() + String0.UNDERLINE + ((Method)this.getTstInfo().getTestMethod().get()).getName() + String0.UNDERLINE + this.getTstSeq() + String0.UNDERLINE + io + String0.DOT + fileType);
        rtn.getParentFile().mkdirs();
        return rtn;
    }

    public File tstFolder() {
        return new File(MAVEN_TEST_ROOT_FOLDER, ((Class)this.getTstInfo().getTestClass().get()).getName().replaceAll(((Class)this.getTstInfo().getTestClass().get()).getSimpleName(), this.getTstFiles()).replaceAll("\\.", String0.SLASH));
    }

    public String tstIContent() {
        return this.tstIContent("txt");
    }

    public String tstIContent(String fileType) {
        return File0.content((Path)this.tstIFiles(fileType).toPath());
    }

    public File tstIFiles() {
        return this.tstIFiles("txt");
    }

    public File tstIFiles(String fileType) {
        return this.tstFiles(this.getTstI(), fileType);
    }

    public String tstOContent() {
        return this.tstOContent("txt");
    }

    public String tstOContent(String fileType) {
        return File0.content((Path)this.tstOFiles(fileType).toPath());
    }

    public File tstOFiles() {
        return this.tstOFiles("txt");
    }

    public File tstOFiles(String fileType) {
        return this.tstFiles(this.getTstO(), fileType);
    }

    public void tstPrint(Object o) {
        log.info(((Method)this.getTstInfo().getTestMethod().get()).getName() + String0.EQUAL + o);
    }

    public String getTstFiles() {
        return this.tstFiles;
    }

    public SKUnit setTstFiles(String tstFiles) {
        this.tstFiles = tstFiles;
        return this;
    }

    public String getTstI() {
        return this.tstI;
    }

    public SKUnit setTstI(String tstI) {
        this.tstI = tstI;
        return this;
    }

    public String getTstO() {
        return this.tstO;
    }

    public SKUnit setTstO(String tstO) {
        this.tstO = tstO;
        return this;
    }

    public String getTstSeq() {
        return this.tstSeq;
    }

    public SKUnit setTstSeq(String tstSeq) {
        this.tstSeq = tstSeq;
        return this;
    }

    public Stopwatch0 getStopwatch() {
        return this.stopwatch;
    }

    public SKUnit setStopwatch(Stopwatch0 stopwatch) {
        this.stopwatch = stopwatch;
        return this;
    }

    public TestInfo getTstInfo() {
        return this.tstInfo;
    }

    public SKUnit setTstInfo(TestInfo tstInfo) {
        this.tstInfo = tstInfo;
        return this;
    }
}

