/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.lang.ZeroException;
import org.shaneking.ling.zero.util.Hex0;
import org.shaneking.ling.zero.util.LruMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crypto0 {
    private static final Logger log = LoggerFactory.getLogger(Crypto0.class);
    public static final String ALGORITHM_NAME__AES = "C3";
    public static final String ENCRYPTED_PREFIX = String0.wrapBracket("C3");
    public static final String DEFAULT_SALT = "494c6f7665596f75";
    private static final LruMap<String, Cipher> SALT_DECRYPT_MAP = new LruMap(13);
    private static final LruMap<String, Cipher> SALT_ENCRYPT_MAP = new LruMap(13);

    public static String aesDecrypt(String encrypted) {
        return Crypto0.aesDecrypt(encrypted, true);
    }

    public static String aesDecrypt(String encrypted, boolean quietly) {
        return Crypto0.aesDecrypt(encrypted, DEFAULT_SALT, quietly);
    }

    public static String aesDecrypt(String encrypted, String salt) {
        return Crypto0.aesDecrypt(encrypted, salt, true);
    }

    public static String aesDecrypt(String encrypted, String salt, boolean quietly) {
        return Crypto0.aesDecrypt(encrypted, salt, StandardCharsets.UTF_8, quietly);
    }

    public static String aesDecrypt(String encrypted, String salt, Charset charset, boolean quietly) {
        try {
            return new String(SALT_DECRYPT_MAP.get(salt, () -> {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, new SecretKeySpec(salt.getBytes(charset), "AES"));
                return cipher;
            }).doFinal(Base64.getDecoder().decode(encrypted)));
        }
        catch (Exception e) {
            log.error(String.join((CharSequence)String0.COMMA, encrypted, salt, charset.toString()), (Throwable)e);
            if (quietly) {
                return encrypted;
            }
            throw new ZeroException(e);
        }
    }

    public static String aesEncrypt(String content) {
        return Crypto0.aesEncrypt(content, true);
    }

    public static String aesEncrypt(String content, boolean quietly) {
        return Crypto0.aesEncrypt(content, DEFAULT_SALT);
    }

    public static String aesEncrypt(String content, String salt) {
        return Crypto0.aesEncrypt(content, salt, true);
    }

    public static String aesEncrypt(String content, String salt, boolean quietly) {
        return Crypto0.aesEncrypt(content, salt, StandardCharsets.UTF_8, quietly);
    }

    public static String aesEncrypt(@NonNull String content, String salt, Charset charset, boolean quietly) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        try {
            return Base64.getEncoder().encodeToString(SALT_ENCRYPT_MAP.get(salt, () -> {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, new SecretKeySpec(salt.getBytes(), "AES"));
                return cipher;
            }).doFinal(content.getBytes(charset)));
        }
        catch (Exception e) {
            log.error(String.join((CharSequence)String0.COMMA, content, salt, charset.toString()), (Throwable)e);
            if (quietly) {
                return content;
            }
            throw new ZeroException(e);
        }
    }

    public static String salt() {
        return Crypto0.salt(UUID.randomUUID().toString().split(String0.MINUS)[0]);
    }

    public static String salt(String eightLengthString) {
        if (String0.isNull2Empty(eightLengthString) || eightLengthString.length() != 8) {
            throw new IllegalArgumentException("Must 8 length string : " + eightLengthString);
        }
        return Hex0.encodeHexString(eightLengthString.getBytes());
    }
}

