/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util;

import java.util.ArrayList;
import java.util.Collection;
import lombok.NonNull;

public class FixedList<E>
extends ArrayList<E> {
    public static final int DEFAULT_SIZE = 1300;
    private final int fixedSize;

    public FixedList() {
        this(1300);
    }

    public FixedList(int fixedSize) {
        this.fixedSize = fixedSize;
    }

    @Override
    public boolean add(E e) {
        if (this.size() > this.fixedSize) {
            this.subList(0, this.size() - this.fixedSize).clear();
        } else if (this.size() == this.fixedSize) {
            this.remove(0);
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E element) {
        if (this.size() > this.fixedSize) {
            this.subList(0, this.size() - this.fixedSize).clear();
        } else if (this.size() == this.fixedSize) {
            this.remove(0);
        }
        super.add(Math.min(index, this.size()), element);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        int needRemoveSize = this.size() + c.size() - this.fixedSize;
        if (needRemoveSize > 0) {
            this.subList(0, Math.min(this.size(), needRemoveSize)).clear();
        }
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends E> c) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        int needRemoveSize = this.size() + c.size() - this.fixedSize;
        if (needRemoveSize > 0) {
            if (c.size() > this.fixedSize) {
                this.clear();
                return this.addAll(c);
            }
            this.subList(0, Math.min(this.size(), needRemoveSize)).clear();
            return super.addAll(Math.min(index, this.size()), c);
        }
        return super.addAll(Math.min(index, this.size()), c);
    }
}

