/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.reflect.Array0;
import org.shaneking.ling.zero.util.Iterator0;
import org.shaneking.ling.zero.util.List0;

public class Iterable0 {
    public static boolean elementsEqual(@NonNull Iterable<?> iterable1, @NonNull Iterable<?> iterable2) {
        if (iterable1 == null) {
            throw new NullPointerException("iterable1 is marked non-null but is null");
        }
        if (iterable2 == null) {
            throw new NullPointerException("iterable2 is marked non-null but is null");
        }
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (collection1.size() != collection2.size()) {
                return false;
            }
        }
        return Iterator0.elementsEqual(iterable1.iterator(), iterable2.iterator());
    }

    public static <T> T get(@NonNull Iterable<T> iterable, int position) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        return (T)(iterable instanceof List ? ((List)iterable).get(position) : Iterator0.get(iterable.iterator(), position));
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        return Iterable0.toArray(iterable, Array0.newArray(type, 0));
    }

    static <T> T[] toArray(Iterable<? extends T> iterable, T[] array) {
        return Iterable0.castOrCopyToCollection(iterable).toArray(array);
    }

    private static <E> Collection<E> castOrCopyToCollection(@NonNull Iterable<E> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        return iterable instanceof Collection ? (ArrayList<E>)iterable : List0.newArrayList(iterable.iterator());
    }
}

