/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.Boolean0;
import org.shaneking.ling.zero.util.Iterable0;
import org.shaneking.ling.zero.util.List0;

public class Iterator0 {
    public static int advance(@NonNull Iterator<?> iterator, int numberToAdvance) {
        int i;
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        Boolean0.checkArgument(numberToAdvance >= 0, "numberToAdvance must be nonnegative");
        for (i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return i;
    }

    public static boolean elementsEqual(@NonNull Iterator<?> iterator1, @NonNull Iterator<?> iterator2) {
        if (iterator1 == null) {
            throw new NullPointerException("iterator1 is marked non-null but is null");
        }
        if (iterator2 == null) {
            throw new NullPointerException("iterator2 is marked non-null but is null");
        }
        while (iterator1.hasNext()) {
            Object o2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            if (Objects.equals(o1, o2 = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static <T> T get(@NonNull Iterator<T> iterator, int position) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        Boolean0.checkArgument(position >= 0, "position (" + position + ") must not be negative");
        int skipped = Iterator0.advance(iterator, position);
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException("position (" + position + ") must be less than the number of elements that remained (" + skipped + ")");
        }
        return iterator.next();
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> type) {
        ArrayList<? extends T> list = List0.newArrayList(iterator);
        return Iterable0.toArray(list, type);
    }
}

