/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util.concurrent;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import org.shaneking.ling.zero.lang.AC0;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.FixedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runtime0Callable
implements Callable<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(Runtime0Callable.class);
    private final boolean errorStream;
    private final InputStream inputStream;
    private final int maxRecordSize;
    private final String pauseFlag;
    private final boolean value4pause;

    public Runtime0Callable(InputStream inputStream, boolean errorStream, boolean value4pause, String pauseFlag, int maxRecordSize) {
        this.inputStream = inputStream;
        this.errorStream = errorStream;
        this.value4pause = value4pause;
        this.pauseFlag = pauseFlag;
        this.maxRecordSize = maxRecordSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> call() throws Exception {
        InputStreamReader inputStreamReader;
        LineNumberReader lineNumberReader;
        FixedList<String> rtnList;
        block10: {
            rtnList = new FixedList<String>(this.maxRecordSize);
            rtnList.add(MessageFormat.format("===B:errorStream={0},value4pause={1},pauseFlag={2}===", this.isErrorStream(), this.isValue4pause(), this.getPauseFlag()));
            lineNumberReader = null;
            inputStreamReader = null;
            String line = null;
            try {
                inputStreamReader = new InputStreamReader(this.getInputStream());
                lineNumberReader = new LineNumberReader(inputStreamReader);
                if (String0.isNull2Empty(this.getPauseFlag())) {
                    while ((line = lineNumberReader.readLine()) != null) {
                        rtnList.add(line);
                        if (this.isErrorStream()) {
                            log.warn(line);
                            continue;
                        }
                        log.info(line);
                    }
                    break block10;
                }
                while ((line = lineNumberReader.readLine()) != null) {
                    rtnList.add(line);
                    if (this.isErrorStream()) {
                        log.warn(line);
                    } else {
                        log.info(line);
                    }
                    if (!line.toLowerCase(Locale.ENGLISH).contains(this.getPauseFlag())) continue;
                    rtnList.add("===P:line contains pauseFlag===");
                    break;
                }
            }
            catch (Exception e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    rtnList.add(e.toString());
                }
                catch (Throwable throwable) {
                    AC0.close(lineNumberReader);
                    AC0.close(inputStreamReader);
                    throw throwable;
                }
                AC0.close(lineNumberReader);
                AC0.close(inputStreamReader);
            }
        }
        AC0.close(lineNumberReader);
        AC0.close(inputStreamReader);
        rtnList.add(MessageFormat.format("===E:errorStream={0},value4pause={1},pauseFlag={2}===", this.isErrorStream(), this.isValue4pause(), this.getPauseFlag()));
        return rtnList;
    }

    public boolean isErrorStream() {
        return this.errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String getPauseFlag() {
        return this.pauseFlag;
    }

    public boolean isValue4pause() {
        return this.value4pause;
    }
}

