/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.List0;
import org.shaneking.ling.zero.util.LruMap;
import org.shaneking.ling.zero.util.Map0;

public interface ZeroCache {
    public static final String ERR_CODE__CACHE_HIT_ALL = "ZERO_CACHE__CACHE_HIT_ALL";
    public static final String ERR_CODE__CACHE_HIT_MISS = "ZERO_CACHE__CACHE_HIT_MISS";
    public static final String ERR_CODE__CACHE_HIT_PART = "ZERO_CACHE__CACHE_HIT_PART";
    public static final LruMap<String, String> LRU_MAP = new LruMap(1023);
    public static final LruMap<String, LruMap<String, String>> LRU_MAP2 = new LruMap(1023);
    public static final ThreadLocal<Map<String, List<String>>> DEL_MAP = ThreadLocal.withInitial(Map0::newHashMap);
    public static final ThreadLocal<Map<String, Map<String, List<String>>>> DEL_MAP2 = ThreadLocal.withInitial(Map0::newHashMap);

    default public String currentTransactionName() {
        return null;
    }

    default public Boolean del(boolean withoutTransactional, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        LRU_MAP.remove(key);
        return true;
    }

    default public Boolean del(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.del(false, key);
    }

    default public String get(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return (String)LRU_MAP.get(key);
    }

    default public Long hdel(boolean withoutTransactional, @NonNull String key, String ... fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        long rtn = 0L;
        LruMap map = (LruMap)LRU_MAP2.get(key);
        if (map != null) {
            for (String field : fields) {
                rtn += String0.isNullOrEmpty((String)map.remove(field)) ? 0L : 1L;
            }
        }
        return rtn;
    }

    default public Long hdel(@NonNull String key, String ... fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        return this.hdel(false, key, fields);
    }

    default public String hget(@NonNull String key, @NonNull String field) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        String rtn = null;
        LruMap map = (LruMap)LRU_MAP2.get(key);
        if (map != null) {
            rtn = (String)map.get(field);
        }
        return rtn;
    }

    @NonNull
    default public List<String> hmget(@NonNull String key, String ... fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        ArrayList<String> rtn = List0.newArrayList();
        LruMap map = (LruMap)LRU_MAP2.get(key);
        if (map != null) {
            for (String field : fields) {
                String value = (String)map.get(field);
                if (value == null) continue;
                rtn.add(value);
            }
        }
        return rtn;
    }

    default public void hmset(@NonNull String key, @NonNull Map<String, String> map) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        LRU_MAP2.computeIfAbsent(key, k -> new LruMap(1023)).putAll(map);
    }

    default public void hset(@NonNull String key, @NonNull String field, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        LRU_MAP2.computeIfAbsent(key, k -> new LruMap(1023)).put(field, value);
    }

    default public boolean inTransactional() {
        return false;
    }

    default public void set(@NonNull String key, int seconds, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        LRU_MAP.put(key, value);
    }

    default public void set(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        LRU_MAP.put(key, value);
    }
}

