/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.crypto;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.lang.ZeroException;
import org.shaneking.ling.zero.util.Hex0;
import org.shaneking.ling.zero.util.LruMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SKC1 {
    private static final Logger log = LoggerFactory.getLogger(SKC1.class);
    public static final String ALGORITHM_NAME = "SKC1";
    public static final String DEFAULT_SALT = "494c6f7665596f75";
    public static final String ENCRYPTED_PREFIX = String0.wrapBracket("SKC1");
    private static final LruMap<String, Cipher> SALT_DECRYPT_MAP = new LruMap(13);
    private static final LruMap<String, Cipher> SALT_ENCRYPT_MAP = new LruMap(13);

    public static String decrypt(String encrypted) {
        return SKC1.decrypt(encrypted, true);
    }

    public static String decrypt(String encrypted, boolean quietly) {
        return SKC1.decrypt(encrypted, DEFAULT_SALT, quietly);
    }

    public static String decrypt(String encrypted, String salt) {
        return SKC1.decrypt(encrypted, salt, true);
    }

    public static String decrypt(String encrypted, String salt, boolean quietly) {
        return SKC1.decrypt(encrypted, salt, StandardCharsets.UTF_8, quietly);
    }

    public static String decrypt(String encrypted, String salt, Charset charset, boolean quietly) {
        try {
            return new String(SALT_DECRYPT_MAP.get(salt, () -> {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(2, new SecretKeySpec(salt.getBytes(charset), "AES"));
                return cipher;
            }).doFinal(Base64.getDecoder().decode(encrypted.getBytes(charset))), charset);
        }
        catch (Exception e) {
            log.error(String.join((CharSequence)String0.COMMA, encrypted, salt, charset.toString()), (Throwable)e);
            if (quietly) {
                return encrypted;
            }
            throw new ZeroException(e);
        }
    }

    public static String encrypt(String content) {
        return SKC1.encrypt(content, true);
    }

    public static String encrypt(String content, boolean quietly) {
        return SKC1.encrypt(content, DEFAULT_SALT, quietly);
    }

    public static String encrypt(String content, String salt) {
        return SKC1.encrypt(content, salt, true);
    }

    public static String encrypt(String content, String salt, boolean quietly) {
        return SKC1.encrypt(content, salt, StandardCharsets.UTF_8, quietly);
    }

    public static String encrypt(@NonNull String content, String salt, Charset charset, boolean quietly) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        try {
            return Base64.getEncoder().encodeToString(SALT_ENCRYPT_MAP.get(salt, () -> {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(1, new SecretKeySpec(salt.getBytes(), "AES"));
                return cipher;
            }).doFinal(content.getBytes(charset)));
        }
        catch (Exception e) {
            log.error(String.join((CharSequence)String0.COMMA, content, salt, charset.toString()), (Throwable)e);
            if (quietly) {
                return content;
            }
            throw new ZeroException(e);
        }
    }

    public static String salt() {
        return SKC1.salt(UUID.randomUUID().toString().split(String0.MINUS)[0]);
    }

    public static String salt(String eightLengthString) {
        if (String0.isNull2Empty(eightLengthString) || eightLengthString.length() != 8) {
            throw new IllegalArgumentException("Must 8 length string : " + eightLengthString);
        }
        return Hex0.encodeHexString(eightLengthString.getBytes());
    }
}

