/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.lang;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.FixedList;
import org.shaneking.ling.zero.util.concurrent.Runtime0Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Runtime0 {
    private static final Logger log = LoggerFactory.getLogger(Runtime0.class);
    public static final long DEFAULT_TIMEOUT_SECONDS = 33L;
    public static final String PAUSE_FLAG_CMD = ">pause";
    public static final String PAUSE_FLAG_SHELL = ">read -n 1 -p";

    public static List<String> exec(String command) {
        return Runtime0.exec(command, 33L);
    }

    public static List<String> exec(String command, boolean value4pause, String pauseFlag) {
        return Runtime0.exec(command, 33L, value4pause, pauseFlag);
    }

    public static List<String> exec(String command, boolean value4pause, String pauseFlag, int maxRecordSize) {
        return Runtime0.exec(command, 33L, value4pause, pauseFlag, maxRecordSize);
    }

    public static List<String> exec(String command, long timeout) {
        return Runtime0.exec(command, timeout, false, null);
    }

    public static List<String> exec(String command, long timeout, boolean value4pause, String pauseFlag) {
        return Runtime0.exec(command, timeout, value4pause, pauseFlag, 1023);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> exec(String command, long timeout, boolean value4pause, String pauseFlag, int maxRecordSize) {
        log.info(command);
        FixedList<String> rtnList = new FixedList<String>(maxRecordSize);
        if (!String0.isNull2Empty(command)) {
            Process process = null;
            Future<List<String>> iFuture = null;
            Future<List<String>> eFuture = null;
            try {
                process = Runtime.getRuntime().exec(command);
                ExecutorService es = Executors.newFixedThreadPool(2);
                iFuture = es.submit(new Runtime0Callable(process.getInputStream(), false, value4pause, pauseFlag, maxRecordSize));
                eFuture = es.submit(new Runtime0Callable(process.getErrorStream(), true, value4pause, pauseFlag, maxRecordSize));
                rtnList.addAll((Collection<String>)iFuture.get(timeout, TimeUnit.SECONDS));
                rtnList.addAll((Collection<String>)eFuture.get(timeout, TimeUnit.SECONDS));
                rtnList.add("process.waitFor()=" + process.waitFor());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                rtnList.add(e.toString());
            }
            finally {
                if (null != iFuture) {
                    iFuture.cancel(true);
                }
                if (null != eFuture) {
                    eFuture.cancel(true);
                }
                if (null != process) {
                    process.destroy();
                }
            }
        }
        return rtnList;
    }

    public static List<String> exec(String command, long timeout, int maxRecordSize) {
        return Runtime0.exec(command, timeout, false, null, maxRecordSize);
    }
}

