/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.lang;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.Char0;
import org.shaneking.ling.zero.util.List0;

public class String0 {
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String AMPERSAND = String.valueOf('&');
    public static final String ANGLE = String.valueOf('\u2220');
    public static final String APPROXIMATELY = String.valueOf('\u2248');
    public static final String ARROW = String.valueOf('\u2192');
    public static final String ARY_BIN = "01";
    public static final String ARY_OCT = "01234567";
    public static final String ARY_DEC = "0123456789";
    public static final String ARY_HEX = "0123456789abcdef";
    public static final String ARY_L62 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String ASTERISK = String.valueOf('*');
    public static final String BACKSLASH = String.valueOf('\\');
    public static final String BACKSPACE = String.valueOf('\b');
    public static final String BLANK = String.valueOf(' ');
    public static final String BR = String.valueOf('\n');
    public static final String BR_LINUX = "\n";
    public static final String BR_MACOS = "\r";
    public static final String BR_WINOS = "\r\n";
    public static final String C7 = String.valueOf('\u0007');
    public static final String C9 = String.valueOf('\t');
    public static final String C10 = String.valueOf('\n');
    public static final String C12 = String.valueOf('\f');
    public static final String C13 = String.valueOf('\r');
    public static final String C27 = String.valueOf('\u001b');
    public static final String C127 = String.valueOf('\u007f');
    public static final String CELSIUS = String.valueOf('\u2103');
    public static final String CIRCLE = String.valueOf('\u2299');
    public static final String CIRCUMFERENCE = String.valueOf('\u25cb');
    public static final String CLOSE_BRACE = String.valueOf('}');
    public static final String CLOSE_BRACKET = String.valueOf(']');
    public static final String CLOSE_PARENTHESIS = String.valueOf(')');
    public static final String COLON = String.valueOf(':');
    public static final String COMMA = String.valueOf(',');
    public static final String DASH = String.valueOf('-');
    public static final String DEGREE = String.valueOf('\u00b0');
    public static final String DIGITAL = "0123456789";
    public static final String DIVIDE = String.valueOf('\u00f7');
    public static final String DOT = String.valueOf('.');
    public static final String DOT_CN = String.valueOf('\u3002');
    public static final String DOUBLE_QUOTATION = String.valueOf('\"');
    public static final String EMAIL = String.valueOf('@');
    public static final String EMPTY = "";
    public static final String EQUAL = String.valueOf('=');
    public static final String EQUAL_APPROXIMATELY = String.valueOf('\u224c');
    public static final String EQUIVALENT = String.valueOf('\u2261');
    public static final String ESCAPE_B = String.valueOf('\b');
    public static final String ESCAPE_N = String.valueOf('\n');
    public static final String ESCAPE_R = String.valueOf('\r');
    public static final String ESCAPE_T = String.valueOf('\t');
    public static final String EXCLAMATION = String.valueOf('!');
    public static final String F = String.valueOf('F');
    public static final String FEMALE = String.valueOf('\u2640');
    public static final String GRAVE_ACCENT = String.valueOf('`');
    public static final String HENCE = String.valueOf('\u2234');
    public static final String I = String.valueOf('I');
    public static final String INFINITY = String.valueOf('\u221e');
    public static final String INTEGRAL = String.valueOf('\u222b');
    public static final String INTERSECTION = String.valueOf('\u2229');
    public static final String LESS = String.valueOf('<');
    public static final String LESS_EQUAL = String.valueOf('\u2264');
    public static final String MALE = String.valueOf('\u2642');
    public static final String MINUS = String.valueOf('-');
    public static final String MINUTE = String.valueOf('\u2032');
    public static final String MULTIPLY = String.valueOf('\u00d7');
    public static final String MORE = String.valueOf('>');
    public static final String MORE_EQUAL = String.valueOf('\u2265');
    public static final String N = String.valueOf('N');
    public static final String NOT_EQUAL = String.valueOf('\u2260');
    public static final String NOT_LESS = String.valueOf('\u226e');
    public static final String NOT_MORE = String.valueOf('\u226f');
    public static final String NULL = "NULL";
    public static final String O = String.valueOf('O');
    public static final String OPEN_BRACE = String.valueOf('{');
    public static final String OPEN_BRACKET = String.valueOf('[');
    public static final String OPEN_PARENTHESIS = String.valueOf('(');
    public static final String PARALLEL = String.valueOf('\u2016');
    public static final String PERCENT = String.valueOf('%');
    public static final String PERMILL = String.valueOf('\u2030');
    public static final String PERPENDICULAR = String.valueOf('\u22a5');
    public static final String PI = String.valueOf('\u03c0');
    public static final String PLUS = String.valueOf('+');
    public static final String PLUS_MINUS = String.valueOf('\u00b1');
    public static final String POUND = String.valueOf('#');
    public static final String PROPORTION = String.valueOf('\u2237');
    public static final String QUESTION = String.valueOf('?');
    public static final String S = String.valueOf('S');
    public static final String SECOND = String.valueOf('\u3003');
    public static final String SECTION = String.valueOf('\u00a7');
    public static final String SEMICIRCLE = String.valueOf('\u2312');
    public static final String SEMICOLON = String.valueOf(';');
    public static final String SIGMA = String.valueOf('\u2211');
    public static final String SINCE = String.valueOf('\u2235');
    public static final String SINGLE_QUOTATION = String.valueOf('\'');
    public static final String SLASH = String.valueOf('/');
    public static final String SQUARE = String.valueOf('\u221a');
    public static final String T = String.valueOf('T');
    public static final String TRIANGLE = String.valueOf('\u25b3');
    public static final String UNDERLINE = String.valueOf('_');
    public static final String UNION = String.valueOf('\u222a');
    public static final String VARIES = String.valueOf('\u221d');
    public static final String VERTICAL = String.valueOf('|');
    public static final String Y = String.valueOf('Y');

    public static String dbColumn2Field(String string) {
        return String0.dbColumn2Field(string, UNDERLINE);
    }

    public static String dbColumn2Field(String string, String with) {
        return String0.lowerFirst(String0.dbColumn2SetField(string, with));
    }

    public static String dbColumn2SetField(String string) {
        return String0.dbColumn2SetField(string, UNDERLINE);
    }

    public static String dbColumn2SetField(String string, String with) {
        return String0.isNullOrEmpty(string) ? string : String.join((CharSequence)EMPTY, List0.newArrayList(string.split(with)).stream().map(String0::upperFirst).collect(Collectors.toList()));
    }

    public static String emptyToNull(String s) {
        return EMPTY.equals(s) ? null : s;
    }

    public static String field2DbColumn(String string) {
        return String0.field2DbColumn(string, UNDERLINE);
    }

    public static String field2DbColumn(String string, String with) {
        return String0.isNullOrEmpty(string) ? string : String.join((CharSequence)EMPTY, List0.newArrayList(string.split(EMPTY)).stream().map(alphabet -> alphabet.equals(alphabet.toUpperCase()) ? with + alphabet.toLowerCase() : alphabet).collect(Collectors.toList()));
    }

    public static String format(@NonNull String pattern, Object ... args) {
        if (pattern == null) {
            throw new NullPointerException("pattern is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        String rePattern = pattern;
        Matcher m = Pattern.compile("\\{(\\d)\\}").matcher(rePattern);
        while (m.find()) {
            rePattern = rePattern.replace(m.group(), String.valueOf(args[Integer.parseInt(m.group(1))]));
        }
        return rePattern;
    }

    public static boolean isNull2Empty(String s) {
        return String0.isNullOrEmpty(s) || "null".equals(s);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNumeric(String s) {
        boolean rtn = !String0.isNullOrEmpty(s);
        for (int i = 0; rtn && i < s.length(); ++i) {
            rtn = Char0.isDigital(s.charAt(i));
        }
        return rtn;
    }

    public static String join(String d, String ... ss) {
        StringBuilder sb = new StringBuilder();
        for (String s : ss) {
            if (String0.isNullOrEmpty(s)) continue;
            sb.append(d).append(s);
        }
        return sb.length() > d.length() ? sb.substring(d.length()) : sb.toString();
    }

    public static String lower(String s) {
        return s == null ? null : s.toLowerCase();
    }

    public static String lowerFirst(String s) {
        return String0.isNullOrEmpty(s) ? s : s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String maxLenStr(String s, int max) {
        return String0.isNullOrEmpty(s) ? s : (s.length() < max ? s : s.substring(0, max));
    }

    public static String notNull2EmptyTo(String s, String d) {
        return String0.isNull2Empty(s) ? s : d;
    }

    public static String notNull2EmptyTo(String s, @NonNull Supplier<String> ss) {
        if (ss == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        return String0.isNull2Empty(s) ? s : ss.get();
    }

    public static String notNullOrEmptyTo(String s, String d) {
        return String0.isNullOrEmpty(s) ? s : d;
    }

    public static String notNullOrEmptyTo(String s, @NonNull Supplier<String> ss) {
        if (ss == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        return String0.isNullOrEmpty(s) ? s : ss.get();
    }

    public static String null2EmptyTo(String s, String d) {
        return String0.isNull2Empty(s) ? d : s;
    }

    public static String null2EmptyTo(String s, @NonNull Supplier<String> ss) {
        if (ss == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        return String0.isNull2Empty(s) ? ss.get() : s;
    }

    public static String nullOrEmptyTo(String s, String d) {
        return String0.isNullOrEmpty(s) ? d : s;
    }

    public static String nullOrEmptyTo(String s, @NonNull Supplier<String> ss) {
        if (ss == null) {
            throw new NullPointerException("ss is marked non-null but is null");
        }
        return String0.isNullOrEmpty(s) ? ss.get() : s;
    }

    public static String nullTo(String s, String d) {
        return s == null ? d : s;
    }

    public static String nullToEmpty(String s) {
        return String0.nullTo(s, EMPTY);
    }

    public static String repeat(String string, int count) {
        Object[] array = new String[count];
        Arrays.fill(array, string);
        return String.join((CharSequence)EMPTY, (CharSequence[])array);
    }

    public static int sameTotal(String s1, String s2) {
        int rtn = 0;
        if (!String0.isNullOrEmpty(s1) && !String0.isNullOrEmpty(s2)) {
            int min = Math.min(s1.length(), s2.length());
            for (int i = 0; i < min; ++i) {
                if (s1.charAt(i) != s2.charAt(i)) continue;
                ++rtn;
            }
        }
        return rtn;
    }

    public static String type(@NonNull Object a) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        return a.getClass().toString();
    }

    public static String upper(String s) {
        return s == null ? null : s.toUpperCase();
    }

    public static String upperFirst(String s) {
        return String0.isNullOrEmpty(s) ? s : s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String valueOf(Object o) {
        return o == null ? EMPTY : o.toString();
    }

    public static String wrapBlack(String s) {
        return String0.wrapBlack(s, false);
    }

    public static String wrapBrace(String s) {
        return String0.wrapBrace(s, false);
    }

    public static String wrapBracket(String s) {
        return String0.wrapBracket(s, false);
    }

    public static String wrapParenthesis(String s) {
        return String0.wrapParenthesis(s, false);
    }

    public static String wrap(String s, String around) {
        return String0.wrap(s, around, false);
    }

    public static String wrap(String s, String open, String close) {
        return String0.wrap(s, open, close, false);
    }

    public static String wrapBlack(String s, boolean ifNotNullOrEmpty) {
        return String0.wrap(s, BLANK, ifNotNullOrEmpty);
    }

    public static String wrapBrace(String s, boolean ifNotNullOrEmpty) {
        return String0.wrap(s, OPEN_BRACE, CLOSE_BRACE, ifNotNullOrEmpty);
    }

    public static String wrapBracket(String s, boolean ifNotNullOrEmpty) {
        return String0.wrap(s, OPEN_BRACKET, CLOSE_BRACKET, ifNotNullOrEmpty);
    }

    public static String wrapParenthesis(String s, boolean ifNotNullOrEmpty) {
        return String0.wrap(s, OPEN_PARENTHESIS, CLOSE_PARENTHESIS, ifNotNullOrEmpty);
    }

    public static String wrap(String s, String around, boolean ifNotNullOrEmpty) {
        return String0.wrap(s, around, around, ifNotNullOrEmpty);
    }

    public static String wrap(String s, String open, String close, boolean ifNotNullOrEmpty) {
        return ifNotNullOrEmpty && String0.isNullOrEmpty(s) ? s : open + s + close;
    }
}

