/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util.concurrent.locks;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Objects;
import org.shaneking.ling.zero.lang.AC0;
import org.shaneking.ling.zero.lang.Integer0;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.concurrent.locks.DistributedLockable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedFileLock
implements DistributedLockable {
    private static final Logger log = LoggerFactory.getLogger(DistributedFileLock.class);
    private int releases = 3;
    private String lockKey;
    private FileChannel fileChannel;
    private FileLock fileLock;
    private RandomAccessFile randomAccessFile;

    @Override
    public void close() throws Exception {
        AC0.close((AutoCloseable)this.fileLock, Integer0.lt2d(this.releases, 3));
        AC0.close((AutoCloseable)this.fileChannel, Integer0.lt2d(this.releases, 3));
        AC0.close((AutoCloseable)this.randomAccessFile, Integer0.lt2d(this.releases, 3));
        this.lockKey = null;
    }

    @Override
    public DistributedFileLock lock(String lockKey, int tryTimes, int intervalSeconds) {
        this.lockKey = String0.nullOrEmptyTo(this.lockKey, lockKey);
        if (Objects.equals(this.lockKey, lockKey)) {
            try {
                if (!this.locked()) {
                    File lockFile = new File(this.lockKey);
                    lockFile.getParentFile().mkdirs();
                    this.randomAccessFile = new RandomAccessFile(lockFile, "rw");
                    this.fileChannel = this.randomAccessFile.getChannel();
                    for (int times = 0; this.fileLock == null && times < tryTimes; ++times) {
                        if (times > 0) {
                            Thread.sleep(intervalSeconds * 1000);
                        }
                        try {
                            this.fileLock = this.fileChannel.tryLock();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                log.error(this.lockKey, (Throwable)e);
                this.unlock();
            }
            return this;
        }
        throw new IllegalArgumentException(lockKey);
    }

    @Override
    public boolean locked() {
        return this.fileLock != null;
    }

    @Override
    public void unlock() {
        try {
            this.close();
        }
        catch (Exception e) {
            log.error(this.lockKey, (Throwable)e);
        }
    }

    public int getReleases() {
        return this.releases;
    }

    public void setReleases(int releases) {
        this.releases = releases;
    }

    public String getLockKey() {
        return this.lockKey;
    }
}

