/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.net;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.file.Files;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.lang.ZeroException;
import org.shaneking.ling.zero.security.SR0;
import org.shaneking.ling.zero.util.List0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetAddress0 {
    private static final Logger log = LoggerFactory.getLogger(InetAddress0.class);
    public static final long YEAR = 31536000000L;
    public static final long EXPIRATION = 3153600000000L;
    public static final List<CacheEntry0> LOCAL_ADDRESS_LIST = List0.newArrayList();

    public static Object createCacheEntry(String hostName, String[] hostAddresses) {
        try {
            InetAddress[] addresses = new InetAddress[hostAddresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                addresses[i] = InetAddress.getByAddress(hostName, InetAddress.getByName(hostAddresses[i]).getAddress());
            }
            Class<?> clazz = Class.forName("java.net.InetAddress$CacheEntry");
            Constructor<?> constructor = clazz.getDeclaredConstructors()[0];
            constructor.setAccessible(true);
            return constructor.newInstance(addresses, System.currentTimeMillis() + 3153600000000L);
        }
        catch (Exception e) {
            throw new ZeroException(e);
        }
    }

    public static String customAddress(String hostName) {
        List<String> customAddresses = InetAddress0.customAddresses(hostName);
        return customAddresses.size() > 0 ? customAddresses.get(SR0.absInt(customAddresses.size())) : null;
    }

    public static List<String> customAddresses(String hostName) {
        return InetAddress0.virtualHosts(InetAddress0.getAddressCacheMap().get(hostName)).stream().filter(InetAddress0::isCustomHost).map(CacheEntry0::getHostAddress).collect(Collectors.toList());
    }

    public static boolean existInLocalHosts(String hostName) {
        return LOCAL_ADDRESS_LIST.stream().filter(cacheEntry0 -> cacheEntry0.hostName.equalsIgnoreCase(hostName)).count() > 0L;
    }

    public static Map<String, Object> getAddressCacheMap() {
        try {
            Field cacheField = InetAddress.class.getDeclaredField("addressCache");
            cacheField.setAccessible(true);
            Object addressCache = cacheField.get(InetAddress.class);
            Class<?> clazz = addressCache.getClass();
            Field cacheMapField = clazz.getDeclaredField("cache");
            cacheMapField.setAccessible(true);
            return (Map)cacheMapField.get(addressCache);
        }
        catch (Exception e) {
            throw new ZeroException(e);
        }
    }

    public static boolean isCustomHost(CacheEntry0 cacheEntry) {
        return cacheEntry.expiration - System.currentTimeMillis() > 31536000000L;
    }

    public static boolean loadLocalHosts() {
        boolean rtn = false;
        if (LOCAL_ADDRESS_LIST.isEmpty()) {
            try (Stream<String> stream = Files.lines(new File(System.getProperty("os.name").startsWith("Windows") ? "c:/windows/System32/drivers/etc/hosts" : "/etc/hosts").toPath());){
                stream.forEachOrdered(line -> {
                    String[] parts;
                    if (!String0.isNullOrEmpty(line) && !line.startsWith(String0.POUND) && (parts = line.split("\\s+")).length > 1) {
                        for (int i = 1; i < parts.length; ++i) {
                            LOCAL_ADDRESS_LIST.add(new CacheEntry0(parts[i], parts[0]));
                        }
                    }
                });
                rtn = true;
            }
            catch (Exception e) {
                log.error(String0.nullOrEmptyTo(e.getMessage(), e.toString()), (Throwable)e);
            }
        }
        return rtn;
    }

    public static InetAddress localHostExactAddress() {
        try {
            InetAddress candidateAddress = null;
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface iface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (candidateAddress != null) continue;
                    candidateAddress = inetAddr;
                }
            }
            return candidateAddress == null ? InetAddress.getLocalHost() : candidateAddress;
        }
        catch (Exception e) {
            log.error(String.valueOf(e), (Throwable)e);
            return null;
        }
    }

    public static boolean putCustomHost(String hostName, @NonNull String hostAddress) {
        if (hostAddress == null) {
            throw new NullPointerException("hostAddress is marked non-null but is null");
        }
        return InetAddress0.putCustomHost(hostName, hostAddress.split(String0.COMMA));
    }

    public static boolean putCustomHost(String hostName, String[] hostAddresses) {
        boolean rtn = false;
        if (!String0.isNullOrEmpty(hostName) && hostAddresses != null && hostAddresses.length > 0 && !InetAddress0.existInLocalHosts(hostName)) {
            InetAddress0.getAddressCacheMap().put(hostName, InetAddress0.createCacheEntry(hostName, hostAddresses));
            rtn = true;
        }
        return rtn;
    }

    public static boolean reloadLocalHosts() {
        LOCAL_ADDRESS_LIST.clear();
        return InetAddress0.loadLocalHosts();
    }

    public static boolean rmvCustomHost(String hostName) {
        return InetAddress0.getAddressCacheMap().remove(hostName) != null;
    }

    public static String virtualAddress(String hostName) {
        List<String> virtualAddresses = InetAddress0.virtualAddresses(hostName);
        return virtualAddresses.size() > 0 ? virtualAddresses.get(SR0.absInt(virtualAddresses.size())) : null;
    }

    public static List<String> virtualAddresses(String hostName) {
        return InetAddress0.virtualHosts(InetAddress0.getAddressCacheMap().get(hostName)).stream().map(CacheEntry0::getHostAddress).collect(Collectors.toList());
    }

    public static List<CacheEntry0> virtualHosts(Object entry) {
        if (entry == null) {
            return List0.newArrayList();
        }
        try {
            Class<?> clazz = entry.getClass();
            Field expirationField = clazz.getDeclaredField("expiration");
            expirationField.setAccessible(true);
            long expiration = (Long)expirationField.get(entry);
            Field addressesField = clazz.getDeclaredField("addresses");
            addressesField.setAccessible(true);
            return List0.newArrayList((InetAddress[])addressesField.get(entry)).stream().map(address -> new CacheEntry0(address.getHostName(), address.getHostAddress(), expiration)).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new ZeroException(e);
        }
    }

    public static class CacheEntry0 {
        String hostName;
        String hostAddress;
        long expiration;

        public CacheEntry0() {
        }

        public CacheEntry0(String hostName, String hostAddress) {
            this.hostName = hostName;
            this.hostAddress = hostAddress;
        }

        public CacheEntry0(String hostName, String hostAddress, long expiration) {
            this.hostName = hostName;
            this.hostAddress = hostAddress;
            this.expiration = expiration;
        }

        public String toString() {
            return "InetAddress0.CacheEntry0(hostName=" + this.getHostName() + ", hostAddress=" + this.getHostAddress() + ", expiration=" + this.getExpiration() + ")";
        }

        public String getHostName() {
            return this.hostName;
        }

        public CacheEntry0 setHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public String getHostAddress() {
            return this.hostAddress;
        }

        public CacheEntry0 setHostAddress(String hostAddress) {
            this.hostAddress = hostAddress;
            return this;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public CacheEntry0 setExpiration(long expiration) {
            this.expiration = expiration;
            return this;
        }
    }
}

