/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.persistence;

import java.util.List;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.List0;

public class Condition {
    private String le;
    private String op;
    private List<String> cl;
    private String cs;
    private String bw;
    private String ew;
    private String sq;

    public Condition appendVal(@NonNull List<String> valList) {
        if (valList == null) {
            throw new NullPointerException("valList is marked non-null but is null");
        }
        this.setOp("in");
        List<String> clValList = this.getCl();
        if (clValList == null) {
            clValList = List0.newArrayList();
            this.setCl(clValList);
        }
        for (String val : valList) {
            if (this.getCl().contains(val)) continue;
            this.getCl().add(val);
        }
        return this;
    }

    public Condition appendVal(@NonNull String val) {
        if (val == null) {
            throw new NullPointerException("val is marked non-null but is null");
        }
        return this.appendVal(List0.newArrayList(val));
    }

    public Condition resetVal(@NonNull List<String> valList) {
        if (valList == null) {
            throw new NullPointerException("valList is marked non-null but is null");
        }
        return this.setOp("in").setCl(valList);
    }

    public Condition resetVal(@NonNull String val) {
        if (val == null) {
            throw new NullPointerException("val is marked non-null but is null");
        }
        return this.setOp(String0.EQUAL).setCs(val);
    }

    public Condition retainVal(@NonNull List<String> valList) {
        if (valList == null) {
            throw new NullPointerException("valList is marked non-null but is null");
        }
        this.setOp("in");
        List<String> clValList = this.getCl();
        if (clValList == null || clValList.size() < 1) {
            this.setCl(valList);
        } else {
            clValList.retainAll(valList);
        }
        return this;
    }

    public String toString() {
        return "Condition(le=" + this.getLe() + ", op=" + this.getOp() + ", cl=" + this.getCl() + ", cs=" + this.getCs() + ", bw=" + this.getBw() + ", ew=" + this.getEw() + ", sq=" + this.getSq() + ")";
    }

    public String getLe() {
        return this.le;
    }

    public Condition setLe(String le) {
        this.le = le;
        return this;
    }

    public String getOp() {
        return this.op;
    }

    public Condition setOp(String op) {
        this.op = op;
        return this;
    }

    public List<String> getCl() {
        return this.cl;
    }

    public Condition setCl(List<String> cl) {
        this.cl = cl;
        return this;
    }

    public String getCs() {
        return this.cs;
    }

    public Condition setCs(String cs) {
        this.cs = cs;
        return this;
    }

    public String getBw() {
        return this.bw;
    }

    public Condition setBw(String bw) {
        this.bw = bw;
        return this;
    }

    public String getEw() {
        return this.ew;
    }

    public Condition setEw(String ew) {
        this.ew = ew;
        return this;
    }

    public String getSq() {
        return this.sq;
    }

    public Condition setSq(String sq) {
        this.sq = sq;
        return this;
    }
}

