/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.time;

import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import lombok.NonNull;
import org.shaneking.ling.zero.lang.Boolean0;

public class Stopwatch0 {
    private final LongSupplier ticker;
    private boolean isRunning;
    private long elapsedNanos;
    private long startTick;

    Stopwatch0() {
        this.ticker = System::nanoTime;
    }

    Stopwatch0(@NonNull LongSupplier ticker) {
        if (ticker == null) {
            throw new NullPointerException("ticker is marked non-null but is null");
        }
        this.ticker = ticker;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    public static Stopwatch0 createStarted() {
        return new Stopwatch0().start();
    }

    public static Stopwatch0 createStarted(LongSupplier ticker) {
        return new Stopwatch0(ticker).start();
    }

    public static Stopwatch0 createUnstarted() {
        return new Stopwatch0();
    }

    public static Stopwatch0 createUnstarted(LongSupplier ticker) {
        return new Stopwatch0(ticker);
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    public long elapsed(@NonNull TimeUnit desiredUnit) {
        if (desiredUnit == null) {
            throw new NullPointerException("desiredUnit is marked non-null but is null");
        }
        return desiredUnit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    private long elapsedNanos() {
        return this.isRunning ? this.ticker.getAsLong() - this.startTick + this.elapsedNanos : this.elapsedNanos;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public Stopwatch0 reset() {
        this.elapsedNanos = 0L;
        this.isRunning = false;
        return this;
    }

    public Stopwatch0 start() {
        Boolean0.checkState(!this.isRunning, "This stopwatch is already running.");
        this.isRunning = true;
        this.startTick = this.ticker.getAsLong();
        return this;
    }

    public Stopwatch0 stop() {
        long tick = this.ticker.getAsLong();
        Boolean0.checkState(this.isRunning, "This stopwatch is already stopped.");
        this.isRunning = false;
        this.elapsedNanos += tick - this.startTick;
        return this;
    }

    public String toString() {
        long nanos = this.elapsedNanos();
        TimeUnit unit = Stopwatch0.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return String.format(Locale.ROOT, "%.4g", value) + " " + Stopwatch0.abbreviate(unit);
    }
}

