/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.ling.zero.util.concurrent;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.shaneking.ling.zero.lang.ZeroException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvictingQueue<T>
extends LinkedBlockingQueue<T> {
    private static final Logger log = LoggerFactory.getLogger(EvictingQueue.class);
    public static final int DEFAULT_CAPACITY = 1023;

    public EvictingQueue() {
        this(1023);
    }

    public EvictingQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean add(T t) {
        return this.offer(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean rtn = true;
        for (T t : c) {
            rtn = rtn && this.offer(t);
        }
        return rtn;
    }

    @Override
    public boolean offer(T t) {
        if (super.offer(t)) {
            return true;
        }
        super.poll();
        return super.offer(t);
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) {
        return this.offer(t, timeout, unit, true);
    }

    public boolean offer(T t, long timeout, TimeUnit unit, boolean quietly) {
        try {
            if (super.offer(t, timeout, unit)) {
                return true;
            }
            super.poll();
            return super.offer(t, timeout, unit);
        }
        catch (Exception e) {
            if (quietly) {
                log.error(String.valueOf(t), (Throwable)e);
                return false;
            }
            throw new ZeroException(e);
        }
    }

    @Override
    public void put(T t) {
        if (!this.offer(t)) {
            log.warn(String.valueOf(t));
        }
    }
}

