/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.aspectj;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.aspectj.weaver.loadtime.WeavingURLClassLoader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.runners.statements.ExpectException;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.shaneking.aspectj.AspectJConfig;

public class AspectJUnit4Runner
extends BlockJUnit4ClassRunner {
    private WeavingURLClassLoader cl;
    private TestClass testClass;

    public AspectJUnit4Runner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    private static <T> Class<T> loadClassFromClassLoader(Class<T> clazz, ClassLoader cl) {
        Class<?> loaded;
        try {
            loaded = Class.forName(clazz.getName(), true, cl);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return loaded;
    }

    protected TestClass createTestClass(Class<?> clazz) {
        URL[] classpath = this.computeClasspath(clazz);
        this.cl = new WeavingURLClassLoader(classpath, null);
        clazz = AspectJUnit4Runner.loadClassFromClassLoader(clazz, (ClassLoader)this.cl);
        this.testClass = new TestClass(clazz);
        return this.testClass;
    }

    private URL[] computeClasspath(Class<?> clazz) {
        URLClassLoader originalClassLoader = (URLClassLoader)clazz.getClassLoader();
        URL[] classpath = originalClassLoader.getURLs();
        AspectJConfig config = clazz.getAnnotation(AspectJConfig.class);
        if (config != null) {
            classpath = this.appendToClasspath(classpath, config.classpathAdditions());
        }
        return classpath;
    }

    private URL[] appendToClasspath(URL[] classpath, String[] urls) {
        URL[] extended = Arrays.copyOf(classpath, classpath.length + urls.length);
        for (int i = 0; i < urls.length; ++i) {
            URL url;
            try {
                url = Paths.get(urls[i], new String[0]).toAbsolutePath().toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            extended[classpath.length + i] = url;
        }
        return extended;
    }

    protected List<FrameworkMethod> computeTestMethods() {
        Class<Test> test = AspectJUnit4Runner.loadClassFromClassLoader(Test.class, (ClassLoader)this.cl);
        return this.getTestClass().getAnnotatedMethods(test);
    }

    protected Statement possiblyExpectingExceptions(FrameworkMethod frameworkMethod, Object testInstance, Statement next) {
        Class<Throwable> expectedException = this.getExpectedException(frameworkMethod);
        if (expectedException == null) {
            Annotation annotation = frameworkMethod.getAnnotation(AspectJUnit4Runner.loadClassFromClassLoader(Test.class, (ClassLoader)this.cl));
            String[] members = annotation.toString().split("expected=class ");
            String exceptionClass = members[members.length - 1];
            exceptionClass = exceptionClass.endsWith(")") ? exceptionClass.substring(0, exceptionClass.length() - 1) : exceptionClass;
            try {
                if (!"org.junit.Test$None".equals(exceptionClass)) {
                    expectedException = Class.forName(exceptionClass, true, (ClassLoader)this.cl);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return expectedException != null ? new ExpectException(next, expectedException) : next;
    }

    protected Class<? extends Throwable> getExpectedException(FrameworkMethod frameworkMethod) {
        Test test = null;
        try {
            test = (Test)frameworkMethod.getAnnotation(AspectJUnit4Runner.loadClassFromClassLoader(Test.class, (ClassLoader)this.cl));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return test != null && test.expected() != Test.None.class ? test.expected() : null;
    }

    public void run(RunNotifier notifier) {
        Exception firstException = null;
        try {
            super.run(notifier);
        }
        catch (Exception e) {
            firstException = e;
            throw e;
        }
        finally {
            try {
                this.cl.close();
            }
            catch (IOException e) {
                RuntimeException rte = new RuntimeException("Failed to close AspectJ classloader.", e);
                if (firstException != null) {
                    rte.addSuppressed(firstException);
                }
                throw rte;
            }
        }
    }

    protected Statement withBeforeClasses(Statement statement) {
        Class<BeforeClass> beforeClass = AspectJUnit4Runner.loadClassFromClassLoader(BeforeClass.class, (ClassLoader)this.cl);
        List befores = this.testClass.getAnnotatedMethods(beforeClass);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, null);
    }

    protected Statement withAfterClasses(Statement statement) {
        Class<AfterClass> afterClass = AspectJUnit4Runner.loadClassFromClassLoader(AfterClass.class, (ClassLoader)this.cl);
        List afters = this.testClass.getAnnotatedMethods(afterClass);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, null);
    }

    protected Statement withBefores(FrameworkMethod method, Object target, Statement statement) {
        Class<Before> before = AspectJUnit4Runner.loadClassFromClassLoader(Before.class, (ClassLoader)this.cl);
        List befores = this.getTestClass().getAnnotatedMethods(before);
        return befores.isEmpty() ? statement : new RunBefores(statement, befores, target);
    }

    protected Statement withAfters(FrameworkMethod method, Object target, Statement statement) {
        Class<After> after = AspectJUnit4Runner.loadClassFromClassLoader(After.class, (ClassLoader)this.cl);
        List afters = this.getTestClass().getAnnotatedMethods(after);
        return afters.isEmpty() ? statement : new RunAfters(statement, afters, target);
    }
}

