/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.skavax.servlet.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletRequestWrapper0
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpServletRequestWrapper0.class);
    private byte[] requestBytes = null;

    public HttpServletRequestWrapper0(HttpServletRequest request) {
        super(request);
        try {
            if (request.getInputStream() == null) {
                this.requestBytes = new byte[0];
            } else {
                ServletInputStream in = request.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
                out.flush();
                this.requestBytes = out.toByteArray();
            }
        }
        catch (IOException e) {
            log.error("Wrapper requestBytes failed.", (Throwable)e);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestBytes == null) {
            this.requestBytes = new byte[0];
        }
        final ByteArrayInputStream in = new ByteArrayInputStream(this.requestBytes);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return in.read();
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public byte[] getRequestBytes() {
        return this.requestBytes;
    }
}

