/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.test;

import com.google.common.base.Stopwatch;
import java.io.File;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.shaneking.skava.lang.String0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SKUnit {
    private static final Logger log = LoggerFactory.getLogger(SKUnit.class);
    public static final File MAVEN_TEST_ROOT_FOLDER = new File("src/test/java");
    @Rule
    public TestName testName = new TestName();
    private Stopwatch stopwatch;
    private Class tstClazz = this.getClass();
    private String tstSeq = null;
    private String tstFiles = "tstfiles";
    private String tstI = String0.I.toLowerCase();
    private String tstO = String0.O.toLowerCase();

    public File tstFolder() {
        return new File(MAVEN_TEST_ROOT_FOLDER, this.getTstClazz().getName().replaceAll(this.getTstClazz().getSimpleName(), this.getTstFiles()).replaceAll("\\.", String0.SLASH));
    }

    public File tstFiles(String io, String fileType) {
        return new File(this.tstFolder(), this.getTstClazz().getSimpleName() + String0.UNDERLINE + this.testName.getMethodName() + String0.UNDERLINE + this.getTstSeq() + String0.UNDERLINE + io + String0.DOT + fileType);
    }

    public File tstIFiles(String fileType) {
        return this.tstFiles(this.getTstI(), fileType);
    }

    public File tstOFiles(String fileType) {
        return this.tstFiles(this.getTstO(), fileType);
    }

    @Before
    public void tstBefore() {
        this.setStopwatch(Stopwatch.createStarted());
    }

    @After
    public void tstAfter() {
        log.info(this.testName.getMethodName() + String0.EQUAL + this.getStopwatch().stop());
    }

    public void tstPrint(Object o) {
        log.info(this.testName.getMethodName() + String0.EQUAL + o);
    }

    public Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    public void setStopwatch(Stopwatch stopwatch) {
        this.stopwatch = stopwatch;
    }

    public Class getTstClazz() {
        return this.tstClazz;
    }

    public void setTstClazz(Class tstClazz) {
        this.tstClazz = tstClazz;
    }

    public String getTstSeq() {
        return this.tstSeq;
    }

    public void setTstSeq(String tstSeq) {
        this.tstSeq = tstSeq;
    }

    public String getTstFiles() {
        return this.tstFiles;
    }

    public void setTstFiles(String tstFiles) {
        this.tstFiles = tstFiles;
    }

    public String getTstI() {
        return this.tstI;
    }

    public void setTstI(String tstI) {
        this.tstI = tstI;
    }

    public String getTstO() {
        return this.tstO;
    }

    public void setTstO(String tstO) {
        this.tstO = tstO;
    }
}

