/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr;

import com.fasterxml.jackson.core.type.TypeReference;
import lombok.NonNull;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.crypto.SKC1;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.roc.rr.Pri;
import org.shaneking.roc.rr.Req;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class RrCryptoHelper {
    private static final Logger log = LoggerFactory.getLogger(RrCryptoHelper.class);
    @Autowired
    private Environment environment;

    public <O, R> Req<O, R> decrypt(@NonNull Req<O, R> respData, String tokenValue, String tokenAlgorithmType, String tokenValueType, TypeReference<Pri<O, R>> typeReference) {
        if (respData == null) {
            throw new NullPointerException("respData is marked non-null but is null");
        }
        String token = tokenValue;
        if (!String0.isNullOrEmpty((String)token) && "PROP".equalsIgnoreCase(tokenValueType)) {
            token = this.environment.getProperty(token, token);
        }
        if (respData.getPri() == null) {
            if (String0.isNullOrEmpty((String)tokenValue) && String0.Y.equalsIgnoreCase(respData.getPub().getEncoded())) {
                throw new IllegalArgumentException(OM3.p((Object[])new Object[]{respData, tokenValue, tokenAlgorithmType, tokenValueType}));
            }
            log.info(OM3.writeValueAsString(respData));
            if ("SKC1".equalsIgnoreCase(tokenAlgorithmType)) {
                respData.setPri((Pri)OM3.readValue((String)SKC1.decrypt((String)respData.getEnc(), (String)token), typeReference)).setEnc(null);
            } else if (String0.Y.equalsIgnoreCase(respData.getPub().getEncoded())) {
                throw new IllegalArgumentException(OM3.p((Object[])new Object[]{respData, tokenValue, tokenAlgorithmType, tokenValueType}));
            }
            log.info(OM3.writeValueAsString(respData));
        }
        return respData;
    }

    public <O, R> Resp<Req<O, R>> decrypt(@NonNull Resp<Req<O, R>> resp, String tokenValue, String tokenAlgorithmType, String tokenValueType, TypeReference<Pri<O, R>> typeReference) {
        if (resp == null) {
            throw new NullPointerException("resp is marked non-null but is null");
        }
        this.decrypt((Req)resp.getData(), tokenValue, tokenAlgorithmType, tokenValueType, typeReference);
        return resp;
    }

    public <O, R> Req<O, R> encrypt(@NonNull Req<O, R> req, String tokenValue, String tokenForce, String tokenAlgorithmType, String tokenValueType) {
        if (req == null) {
            throw new NullPointerException("req is marked non-null but is null");
        }
        String token = tokenValue;
        if (!String0.isNullOrEmpty((String)token) && "PROP".equalsIgnoreCase(tokenValueType)) {
            token = this.environment.getProperty(token, token);
        }
        if (String0.isNullOrEmpty((String)req.getEnc())) {
            if (String0.isNullOrEmpty((String)tokenValue) && String0.Y.equalsIgnoreCase(tokenForce)) {
                throw new IllegalArgumentException(OM3.p((Object[])new Object[]{req, req, tokenValue, tokenForce, tokenAlgorithmType, tokenValueType}));
            }
            log.info(OM3.writeValueAsString(req));
            if ("SKC1".equalsIgnoreCase(tokenAlgorithmType)) {
                req.setEnc(SKC1.encrypt((String)OM3.writeValueAsString(req.getPri()), (String)token)).setPri(null).getPub().setEncoded(String0.Y);
            } else if (String0.Y.equalsIgnoreCase(tokenForce)) {
                throw new IllegalArgumentException(OM3.p((Object[])new Object[]{req, tokenValue, tokenForce, tokenAlgorithmType, tokenValueType}));
            }
            log.info(OM3.writeValueAsString(req));
        }
        return req;
    }
}

