/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.roc.persistence.CacheableEntities;
import org.shaneking.roc.persistence.dao.CacheableDao;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessRegexApiEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessSignatureApiEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessTenantRegexApiEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessTenantSignatureApiEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessTenantUrlApiEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelAccessUrlApiEntities;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.access", value={"enabled"}, matchIfMissing=true)
@Order(value=50000)
public class RrAccessAspect {
    private static final Logger log = LoggerFactory.getLogger(RrAccessAspect.class);
    public static final int ORDER = 50000;
    @Value(value="${sk.roc.rr.access.enabled:true}")
    private boolean enabled;
    @Autowired
    private CacheableDao cacheableDao;
    @Autowired(required=false)
    private ChannelAccessRegexApiEntities channelAccessRegexApiEntityClass;
    @Autowired(required=false)
    private ChannelAccessSignatureApiEntities channelAccessSignatureApiEntityClass;
    @Autowired(required=false)
    private ChannelAccessTenantRegexApiEntities channelAccessTenantRegexApiEntityClass;
    @Autowired(required=false)
    private ChannelAccessTenantSignatureApiEntities channelAccessTenantSignatureApiEntityClass;
    @Autowired(required=false)
    private ChannelAccessTenantUrlApiEntities channelAccessTenantUrlApiEntityClass;
    @Autowired(required=false)
    private ChannelAccessUrlApiEntities channelAccessUrlApiEntityClass;

    @Around(value="pointcut() && @annotation(rrAccess)")
    public Object around(ProceedingJoinPoint pjp, RrAccess rrAccess) throws Throwable {
        Object rtn;
        block16: {
            rtn = null;
            boolean ifExceptionThenInProceed = false;
            if (this.enabled && (this.channelAccessRegexApiEntityClass != null || this.channelAccessUrlApiEntityClass != null || this.channelAccessSignatureApiEntityClass != null || this.channelAccessTenantRegexApiEntityClass != null || this.channelAccessTenantUrlApiEntityClass != null || this.channelAccessTenantSignatureApiEntityClass != null)) {
                if (pjp.getArgs().length > rrAccess.reqParamIdx() && pjp.getArgs()[rrAccess.reqParamIdx()] instanceof Req) {
                    Req req = (Req)pjp.getArgs()[rrAccess.reqParamIdx()];
                    if (String0.isNullOrEmpty((String)req.gnnCtx().gnaChannelId()) || String0.isNullOrEmpty((String)req.gnnCtx().gnaTenantId())) {
                        rtn = Resp.failed((String)"TENANTED_CHANNELIZED_ENTITY__REQUIRED_CHANNEL_ID_AND_TENANT_ID", (String)OM3.writeValueAsString((Object)req.getPub()), (Object)req);
                    } else {
                        try {
                            int regexPaas = 0;
                            int urlPaas = 0;
                            int signaturePaas = 0;
                            ChannelAccessRegexApiEntities channelAccessRegexApiEntity = null;
                            ChannelAccessUrlApiEntities channelAccessUrlApiEntity = null;
                            ChannelAccessSignatureApiEntities channelAccessSignatureApiEntity = null;
                            ChannelAccessTenantRegexApiEntities channelAccessTenantRegexApiEntity = null;
                            ChannelAccessTenantUrlApiEntities channelAccessTenantUrlApiEntity = null;
                            ChannelAccessTenantSignatureApiEntities channelAccessTenantSignatureApiEntity = null;
                            if (this.channelAccessRegexApiEntityClass != null) {
                                ChannelAccessRegexApiEntities channelAccessRegexApiEntitySelect = (ChannelAccessRegexApiEntities)this.channelAccessRegexApiEntityClass.entityClass().newInstance();
                                channelAccessRegexApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessRegexApiEntity = (ChannelAccessRegexApiEntities)this.cacheableDao.one(this.channelAccessRegexApiEntityClass.entityClass(), (CacheableEntities)channelAccessRegexApiEntitySelect, true);
                                int n = channelAccessRegexApiEntity == null ? 0 : (regexPaas = channelAccessRegexApiEntity.check(req.gnnCtx().getAuditLog() == null ? null : req.gnnCtx().getAuditLog().getReqUrl(), pjp.getSignature().toLongString()) ? 1 : -1);
                            }
                            if (this.channelAccessUrlApiEntityClass != null && req.gnnCtx().getAuditLog() != null && !String0.isNullOrEmpty((String)req.gnnCtx().getAuditLog().getReqUrl())) {
                                ChannelAccessUrlApiEntities channelAccessUrlApiEntitySelect = (ChannelAccessUrlApiEntities)this.channelAccessUrlApiEntityClass.entityClass().newInstance();
                                channelAccessUrlApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessUrlApiEntitySelect.setUrl(req.gnnCtx().getAuditLog().getReqUrl());
                                channelAccessUrlApiEntity = (ChannelAccessUrlApiEntities)this.cacheableDao.one(this.channelAccessUrlApiEntityClass.entityClass(), (CacheableEntities)channelAccessUrlApiEntitySelect, true);
                                urlPaas += channelAccessUrlApiEntity == null ? 0 : ("A".equals(channelAccessUrlApiEntity.getOp()) ? 2 : ("D".equals(channelAccessUrlApiEntity.getOp()) ? -2 : 0));
                            }
                            if (this.channelAccessSignatureApiEntityClass != null) {
                                ChannelAccessSignatureApiEntities channelAccessSignatureApiEntitySelect = (ChannelAccessSignatureApiEntities)this.channelAccessSignatureApiEntityClass.entityClass().newInstance();
                                channelAccessSignatureApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessSignatureApiEntitySelect.setSignature(pjp.getSignature().toLongString());
                                channelAccessSignatureApiEntity = (ChannelAccessSignatureApiEntities)this.cacheableDao.one(this.channelAccessSignatureApiEntityClass.entityClass(), (CacheableEntities)channelAccessSignatureApiEntitySelect, true);
                                signaturePaas += channelAccessSignatureApiEntity == null ? 0 : ("A".equals(channelAccessSignatureApiEntity.getOp()) ? 2 : ("D".equals(channelAccessSignatureApiEntity.getOp()) ? -2 : 0));
                            }
                            if (this.channelAccessTenantRegexApiEntityClass != null) {
                                ChannelAccessTenantRegexApiEntities channelAccessTenantRegexApiEntitySelect = (ChannelAccessTenantRegexApiEntities)this.channelAccessTenantRegexApiEntityClass.entityClass().newInstance();
                                channelAccessTenantRegexApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessTenantRegexApiEntitySelect.setTenantId(req.gnnCtx().gnaTenantId());
                                channelAccessTenantRegexApiEntity = (ChannelAccessTenantRegexApiEntities)this.cacheableDao.one(this.channelAccessTenantRegexApiEntityClass.entityClass(), (CacheableEntities)channelAccessTenantRegexApiEntitySelect, true);
                                int n = channelAccessTenantRegexApiEntity == null ? 0 : (regexPaas = channelAccessTenantRegexApiEntity.check(req.gnnCtx().getAuditLog() == null ? null : req.gnnCtx().getAuditLog().getReqUrl(), pjp.getSignature().toLongString()) ? 4 : -4);
                            }
                            if (this.channelAccessTenantUrlApiEntityClass != null && req.gnnCtx().getAuditLog() != null && !String0.isNullOrEmpty((String)req.gnnCtx().getAuditLog().getReqUrl())) {
                                ChannelAccessTenantUrlApiEntities channelAccessTenantUrlApiEntitySelect = (ChannelAccessTenantUrlApiEntities)this.channelAccessTenantUrlApiEntityClass.entityClass().newInstance();
                                channelAccessTenantUrlApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessTenantUrlApiEntitySelect.setTenantId(req.gnnCtx().gnaTenantId());
                                channelAccessTenantUrlApiEntitySelect.setUrl(req.gnnCtx().getAuditLog().getReqUrl());
                                channelAccessTenantUrlApiEntity = (ChannelAccessTenantUrlApiEntities)this.cacheableDao.one(this.channelAccessTenantUrlApiEntityClass.entityClass(), (CacheableEntities)channelAccessTenantUrlApiEntitySelect, true);
                                urlPaas += channelAccessTenantUrlApiEntity == null ? 0 : ("A".equals(channelAccessTenantUrlApiEntity.getOp()) ? 8 : ("D".equals(channelAccessTenantUrlApiEntity.getOp()) ? -8 : 0));
                            }
                            if (this.channelAccessTenantSignatureApiEntityClass != null) {
                                ChannelAccessTenantSignatureApiEntities channelAccessTenantSignatureApiEntitySelect = (ChannelAccessTenantSignatureApiEntities)this.channelAccessTenantSignatureApiEntityClass.entityClass().newInstance();
                                channelAccessTenantSignatureApiEntitySelect.setChannelId(req.gnnCtx().gnaChannelId());
                                channelAccessTenantSignatureApiEntitySelect.setTenantId(req.gnnCtx().gnaTenantId());
                                channelAccessTenantSignatureApiEntitySelect.setSignature(pjp.getSignature().toLongString());
                                channelAccessTenantSignatureApiEntity = (ChannelAccessTenantSignatureApiEntities)this.cacheableDao.one(this.channelAccessTenantSignatureApiEntityClass.entityClass(), (CacheableEntities)channelAccessTenantSignatureApiEntitySelect, true);
                                signaturePaas += channelAccessTenantSignatureApiEntity == null ? 0 : ("A".equals(channelAccessTenantSignatureApiEntity.getOp()) ? 8 : ("D".equals(channelAccessTenantSignatureApiEntity.getOp()) ? -8 : 0));
                            }
                            if (regexPaas + urlPaas + signaturePaas > 0) {
                                ifExceptionThenInProceed = true;
                                rtn = pjp.proceed();
                                break block16;
                            }
                            rtn = Resp.failed((String)"API_ACCESS_OP__PERMISSION_DENIED", (String)OM3.p((Object[])new Object[]{channelAccessTenantRegexApiEntity, channelAccessTenantUrlApiEntity, channelAccessTenantSignatureApiEntity}), (Object)req);
                        }
                        catch (Throwable throwable) {
                            log.error(OM3.writeValueAsString((Object)req), throwable);
                            if (ifExceptionThenInProceed) {
                                throw throwable;
                            }
                            rtn = Resp.failed((String)"-1", (String)String.valueOf(throwable), (Object)req);
                        }
                    }
                } else {
                    log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrAccess)}));
                    rtn = pjp.proceed();
                }
            } else {
                rtn = pjp.proceed();
            }
        }
        return rtn;
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrAccess * *..*.*(..))")
    private void pointcut() {
    }
}

