/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.lang.Integer0;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.ling.zero.util.UUID0;
import org.shaneking.roc.persistence.CacheableEntities;
import org.shaneking.roc.persistence.dao.NumberedDao;
import org.shaneking.roc.persistence.entity.sql.RrAsyncLogEntities;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrAsync;
import org.shaneking.roc.rr.aspectj.RrAsyncAspectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.async", value={"enabled"}, matchIfMissing=true)
@Order(value=80000)
public class RrAsyncAspect {
    private static final Logger log = LoggerFactory.getLogger(RrAsyncAspect.class);
    public static final int ORDER = 80000;
    @Value(value="${sk.roc.rr.async.enabled:true}")
    private boolean enabled;
    @Autowired
    private NumberedDao numberedDao;
    @Autowired
    private RrAsyncAspectHelper asyncAspectHelper;
    @Autowired(required=false)
    private RrAsyncLogEntities asyncLogEntities;

    @Around(value="pointcut() && @annotation(rrAsync)")
    public Object around(ProceedingJoinPoint pjp, RrAsync rrAsync) throws Throwable {
        Resp<?> rtn = null;
        if (this.enabled) {
            if (pjp.getArgs().length > rrAsync.reqParamIdx() && pjp.getArgs()[rrAsync.reqParamIdx()] instanceof Req) {
                Req req = (Req)pjp.getArgs()[rrAsync.reqParamIdx()];
                if (Integer0.null2Zero((Integer)req.getPri().gnnExt().getAsync()) > 0 && this.asyncLogEntities != null) {
                    RrAsyncLogEntities asyncLogEntity = (RrAsyncLogEntities)this.numberedDao.oneByNo(this.asyncLogEntities.entityClass(), req.getPub().gnnReqNo(), true);
                    if (asyncLogEntity == null) {
                        asyncLogEntity = (RrAsyncLogEntities)this.asyncLogEntities.entityClass().newInstance();
                        asyncLogEntity.setReqJsonStrRaw(OM3.writeValueAsString((Object)req)).setCtxJsonStr(OM3.writeValueAsString((Object)req.gnnCtx())).setTenantId(req.gnnCtx().gnaTenantId());
                        asyncLogEntity.setNo(req.getPub().gnnReqNo());
                        asyncLogEntity.initWithUidAndId(req.gnnCtx().gnaUserId(), String0.nullOrEmptyTo((String)req.gnnCtx().gnaAuditId(), (String)UUID0.cUl33()));
                        this.numberedDao.getCacheableDao().add(this.asyncLogEntities.entityClass(), (CacheableEntities)asyncLogEntity);
                        RrAsyncLogEntities modAsyncLogEntity = (RrAsyncLogEntities)this.asyncLogEntities.entityClass().newInstance();
                        modAsyncLogEntity.setId(asyncLogEntity.getId());
                        Future<Resp<?>> respFuture = this.asyncAspectHelper.async(pjp, req, modAsyncLogEntity);
                        try {
                            rtn = respFuture.get(req.getPri().gnnExt().getAsync().intValue(), TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | ExecutionException | TimeoutException e) {
                            rtn = Resp.success((Object)req);
                        }
                    } else {
                        Resp resp = Resp.success((Object)req);
                        if (!String0.isNullOrEmpty((String)asyncLogEntity.getRtnJsonStr())) {
                            req.getPri().setRtn(OM3.readValue((String)asyncLogEntity.getRtnJsonStr(), rrAsync.rtnType()));
                            resp.setCode(String0.nullOrEmptyTo((String)asyncLogEntity.getRtnCode(), (String)"-1"));
                            resp.setMsg(asyncLogEntity.getRtnMsg());
                        }
                        rtn = resp;
                    }
                } else {
                    rtn = pjp.proceed();
                }
            } else {
                log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrAsync)}));
                rtn = pjp.proceed();
            }
        } else {
            rtn = pjp.proceed();
        }
        return rtn;
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrAsync * *..*.*(..))")
    private void pointcut() {
    }
}

