/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.rr.RespException;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.net.InetAddress0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.ling.zero.time.LDT0;
import org.shaneking.ling.zero.time.ZDT0;
import org.shaneking.ling.zero.util.UUID0;
import org.shaneking.roc.persistence.CacheableEntities;
import org.shaneking.roc.persistence.dao.NumberedDao;
import org.shaneking.roc.persistence.entity.sql.ChannelEntities;
import org.shaneking.roc.persistence.entity.sql.RrAuditLogEntities;
import org.shaneking.roc.rr.Ctx;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrAudit;
import org.shaneking.roc.rr.aspectj.RrAuditAspectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.audit", value={"enabled"}, matchIfMissing=true)
@Order(value=20000)
public class RrAuditAspect {
    private static final Logger log = LoggerFactory.getLogger(RrAuditAspect.class);
    public static final int ORDER = 20000;
    @Value(value="${sk.roc.rr.audit.async:true}")
    private boolean async;
    @Value(value="${sk.roc.rr.audit.enabled:true}")
    private boolean enabled;
    @Autowired
    private NumberedDao numberedDao;
    @Autowired(required=false)
    private ChannelEntities channelEntityClass;
    @Autowired
    private RrAuditAspectHelper auditAspectHelper;
    @Autowired(required=false)
    private RrAuditLogEntities auditLogEntityClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Around(value="pointcut() && @annotation(rrAudit)")
    public Object around(ProceedingJoinPoint pjp, RrAudit rrAudit) throws Throwable {
        Object rtn;
        block33: {
            block35: {
                block36: {
                    RrAuditLogEntities auditLogEntity;
                    Req req;
                    boolean ifExceptionThenInProceed;
                    block32: {
                        rtn = null;
                        ifExceptionThenInProceed = false;
                        if (!this.enabled || this.auditLogEntityClass == null || this.channelEntityClass == null) break block35;
                        if (pjp.getArgs().length <= rrAudit.reqParamIdx() || !(pjp.getArgs()[rrAudit.reqParamIdx()] instanceof Req)) break block36;
                        req = (Req)pjp.getArgs()[rrAudit.reqParamIdx()];
                        log.info(OM3.writeValueAsString((Object)req));
                        String reqNo = req.getPub().gnnReqNo();
                        String tracingNo = req.getPub().gnnTracingNo();
                        auditLogEntity = null;
                        auditLogEntity = (RrAuditLogEntities)this.auditLogEntityClass.entityClass().newInstance();
                        auditLogEntity.setId(UUID0.cUl33());
                        auditLogEntity.setNo(reqNo);
                        auditLogEntity.setIvd(String0.N);
                        auditLogEntity.setLmDsz(ZDT0.on().dTSZ());
                        auditLogEntity.setVer(Integer.valueOf(0));
                        auditLogEntity.setTracingNo(tracingNo);
                        auditLogEntity.setReqDatetime(LDT0.on().dts());
                        auditLogEntity.setReqJsonStrRaw(OM3.writeValueAsString((Object)req));
                        auditLogEntity.setReqSignature(pjp.getSignature().toLongString());
                        auditLogEntity.setRespIps(OM3.writeValueAsString((Object)InetAddress0.localHostExactAddress()));
                        req.gnnCtx().setAuditLog(auditLogEntity);
                        if (req.getPub() == null || String0.isNullOrEmpty((String)req.getPub().getChannelNo())) {
                            rtn = Resp.failed((String)"PUB__REQUIRED_CHANNEL_NUMBER", (String)OM3.writeValueAsString((Object)req.getPub()), (Object)req);
                            break block32;
                        }
                        ChannelEntities channelEntity = (ChannelEntities)this.numberedDao.oneByNo(this.channelEntityClass.entityClass(), req.getPub().getChannelNo(), true);
                        if (channelEntity == null) {
                            rtn = Resp.failed((String)"NUMBERED__NOT_FOUND_BY_NUMBER", (String)req.getPub().getChannelNo(), (Object)req);
                            break block32;
                        }
                        req.gnnCtx().setChannel(channelEntity);
                        if (req.gnnCtx().getAuditLog() != null) {
                            req.gnnCtx().getAuditLog().setChannelId(channelEntity.getId());
                        }
                        ifExceptionThenInProceed = true;
                        rtn = pjp.proceed();
                    }
                    try {
                        if (auditLogEntity == null) break block33;
                        auditLogEntity.setLmDsz(ZDT0.on().dTSZ());
                        auditLogEntity.setLmUid(auditLogEntity.getReqUserId());
                        Ctx reqCtx = req.detach();
                        auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)reqCtx));
                        if (rtn != null) {
                            if (rtn instanceof Resp) {
                                Resp resp = (Resp)rtn;
                                if (resp.getData() instanceof Req) {
                                    Req respData = (Req)resp.getData();
                                    if ("null".equals(auditLogEntity.getRespJsonStrCtx()) || "{}".equals(auditLogEntity.getRespJsonStrCtx()) || OM3.writeValueAsString((Object)new Ctx()).equals(auditLogEntity.getRespJsonStrCtx())) {
                                        Ctx respCtx = respData.detach();
                                        auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)respCtx));
                                    }
                                    respData.detach();
                                }
                                resp.detach();
                            }
                            auditLogEntity.setRespJsonStrRaw(OM3.writeValueAsString((Object)rtn));
                        }
                        auditLogEntity.setRespDatetime(LDT0.on().dts());
                        log.info(OM3.writeValueAsString((Object)auditLogEntity));
                        if (this.async) {
                            this.auditAspectHelper.async(auditLogEntity);
                            break block33;
                        }
                        this.numberedDao.getCacheableDao().add(auditLogEntity.entityClass(), (CacheableEntities)auditLogEntity);
                    }
                    catch (Throwable throwable) {
                        log.error(OM3.lp((Object)rtn, (Object[])new Object[]{req, auditLogEntity}), throwable);
                    }
                    break block33;
                    catch (Throwable throwable) {
                        block34: {
                            try {
                                log.error(OM3.lp((Object)rtn, (Object[])new Object[]{req, auditLogEntity}), throwable);
                                if (ifExceptionThenInProceed) {
                                    if (throwable instanceof RespException) {
                                        rtn = Resp.failed((String)"-1", (String)"-1", (Object)req).parseExp((Exception)((RespException)throwable));
                                        break block34;
                                    }
                                    throw throwable;
                                }
                                rtn = pjp.proceed();
                            }
                            catch (Throwable throwable2) {
                                try {
                                    if (auditLogEntity != null) {
                                        auditLogEntity.setLmDsz(ZDT0.on().dTSZ());
                                        auditLogEntity.setLmUid(auditLogEntity.getReqUserId());
                                        Ctx reqCtx = req.detach();
                                        auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)reqCtx));
                                        if (rtn != null) {
                                            if (rtn instanceof Resp) {
                                                Resp resp = (Resp)rtn;
                                                if (resp.getData() instanceof Req) {
                                                    Req respData = (Req)resp.getData();
                                                    if ("null".equals(auditLogEntity.getRespJsonStrCtx()) || "{}".equals(auditLogEntity.getRespJsonStrCtx()) || OM3.writeValueAsString((Object)new Ctx()).equals(auditLogEntity.getRespJsonStrCtx())) {
                                                        Ctx respCtx = respData.detach();
                                                        auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)respCtx));
                                                    }
                                                    respData.detach();
                                                }
                                                resp.detach();
                                            }
                                            auditLogEntity.setRespJsonStrRaw(OM3.writeValueAsString((Object)rtn));
                                        }
                                        auditLogEntity.setRespDatetime(LDT0.on().dts());
                                        log.info(OM3.writeValueAsString((Object)auditLogEntity));
                                        if (this.async) {
                                            this.auditAspectHelper.async(auditLogEntity);
                                        } else {
                                            this.numberedDao.getCacheableDao().add(auditLogEntity.entityClass(), (CacheableEntities)auditLogEntity);
                                        }
                                    }
                                }
                                catch (Throwable throwable3) {
                                    log.error(OM3.lp((Object)rtn, (Object[])new Object[]{req, auditLogEntity}), throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        try {
                            if (auditLogEntity == null) break block33;
                            auditLogEntity.setLmDsz(ZDT0.on().dTSZ());
                            auditLogEntity.setLmUid(auditLogEntity.getReqUserId());
                            Ctx reqCtx = req.detach();
                            auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)reqCtx));
                            if (rtn != null) {
                                if (rtn instanceof Resp) {
                                    Resp resp = (Resp)rtn;
                                    if (resp.getData() instanceof Req) {
                                        Req respData = (Req)resp.getData();
                                        if ("null".equals(auditLogEntity.getRespJsonStrCtx()) || "{}".equals(auditLogEntity.getRespJsonStrCtx()) || OM3.writeValueAsString((Object)new Ctx()).equals(auditLogEntity.getRespJsonStrCtx())) {
                                            Ctx respCtx = respData.detach();
                                            auditLogEntity.setRespJsonStrCtx(OM3.writeValueAsString((Object)respCtx));
                                        }
                                        respData.detach();
                                    }
                                    resp.detach();
                                }
                                auditLogEntity.setRespJsonStrRaw(OM3.writeValueAsString((Object)rtn));
                            }
                            auditLogEntity.setRespDatetime(LDT0.on().dts());
                            log.info(OM3.writeValueAsString((Object)auditLogEntity));
                            if (this.async) {
                                this.auditAspectHelper.async(auditLogEntity);
                                break block33;
                            }
                            this.numberedDao.getCacheableDao().add(auditLogEntity.entityClass(), (CacheableEntities)auditLogEntity);
                        }
                        catch (Throwable throwable4) {
                            log.error(OM3.lp((Object)rtn, (Object[])new Object[]{req, auditLogEntity}), throwable4);
                        }
                        break block33;
                    }
                }
                log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrAudit)}));
                rtn = pjp.proceed();
                break block33;
            }
            rtn = pjp.proceed();
        }
        return rtn;
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrAudit * *..*.*(..))")
    private void pointcut() {
    }
}

