/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import com.fasterxml.jackson.databind.JavaType;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.cache.ZeroCache;
import org.shaneking.ling.zero.lang.Boolean0;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.persistence.Tuple;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.roc.jackson.JavaType3;
import org.shaneking.roc.persistence.entity.sql.RrAuditLogEntities;
import org.shaneking.roc.rr.Ctx;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.cache", value={"enabled"}, matchIfMissing=true)
@Order(value=70000)
public class RrCacheAspect {
    private static final Logger log = LoggerFactory.getLogger(RrCacheAspect.class);
    public static final int ORDER = 70000;
    @Value(value="${sk.roc.rr.cache.enabled:true}")
    private boolean enabled;
    @Autowired(required=false)
    private ZeroCache cache;

    @Around(value="pointcut() && @annotation(rrCache)")
    public Object around(ProceedingJoinPoint pjp, RrCache rrCache) throws Throwable {
        Object rtn;
        block11: {
            rtn = null;
            boolean proceedBefore = false;
            boolean proceedAfter = false;
            if (this.enabled && this.cache != null) {
                if (pjp.getArgs().length > rrCache.reqParamIdx() && pjp.getArgs()[rrCache.reqParamIdx()] instanceof Req) {
                    Req req = (Req)pjp.getArgs()[rrCache.reqParamIdx()];
                    Tuple.Quintuple<Ctx, String, String, String, String> detached = this.detach(req);
                    try {
                        String key = String.join((CharSequence)String0.MORE, pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)req));
                        String respCached = this.cache.get(key);
                        RrAuditLogEntities auditLogEntity = ((Ctx)Tuple.getFirst(detached)).getAuditLog();
                        if (auditLogEntity != null) {
                            auditLogEntity.setCached(Boolean0.yn((!String0.isNullOrEmpty((String)respCached) ? 1 : 0) != 0));
                        }
                        if (String0.isNullOrEmpty((String)respCached)) {
                            log.info(MF0.fmt((String)"{0} - {1}", (Object[])new Object[]{"ZERO_CACHE__CACHE_HIT_MISS", key}));
                            this.attach(req, detached);
                            proceedBefore = true;
                            rtn = pjp.proceed();
                            proceedAfter = true;
                            if (rtn instanceof Resp && ((Resp)rtn).getData() instanceof Req) {
                                Resp resp = (Resp)rtn;
                                Tuple.Pair<Boolean, Tuple.Quintuple<Ctx, String, String, String, String>> respDetached = this.detach(resp);
                                this.cache.set(key, rrCache.cacheSeconds(), OM3.writeValueAsString((Object)rtn));
                                this.attach(resp, respDetached);
                            }
                            break block11;
                        }
                        log.info(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_CACHE__CACHE_HIT_ALL", key, respCached}));
                        Resp resp = (Resp)OM3.readValue((String)respCached, (JavaType)OM3.om().getTypeFactory().constructParametricType(Resp.class, JavaType3.resolveRtnJavaTypes((ProceedingJoinPoint)pjp)));
                        this.attach((Req)resp.getData(), detached);
                        rtn = resp;
                    }
                    catch (Throwable throwable) {
                        log.error(OM3.writeValueAsString((Object)req), throwable);
                        this.attach(req, detached);
                        if (proceedBefore && !proceedAfter) {
                            throw throwable;
                        }
                        if (proceedAfter) {
                            rtn = Resp.failed((String)"-1", (String)String.valueOf(throwable), (Object)req);
                            break block11;
                        }
                        rtn = pjp.proceed();
                    }
                } else {
                    log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrCache)}));
                    rtn = pjp.proceed();
                }
            } else {
                rtn = pjp.proceed();
            }
        }
        return rtn;
    }

    private void attach(Req<?, ?> req, Tuple.Quintuple<Ctx, String, String, String, String> detached) {
        req.attach((Ctx)Tuple.getFirst(detached)).getPub().setReqNo((String)Tuple.getSecond(detached)).setTracingNo((String)Tuple.getThird(detached)).setMvc((String)Tuple.getFifth(detached));
        req.getPri().gnnExt().setDsz((String)Tuple.getFourth(detached));
    }

    private void attach(Resp<?> resp, Tuple.Pair<Boolean, Tuple.Quintuple<Ctx, String, String, String, String>> detached) {
        this.attach((Req)resp.attach((Boolean)Tuple.getFirst(detached)).getData(), (Tuple.Quintuple<Ctx, String, String, String, String>)((Tuple.Quintuple)Tuple.getSecond(detached)));
    }

    private Tuple.Quintuple<Ctx, String, String, String, String> detach(Req<?, ?> req) {
        Tuple.Quintuple rtn = Tuple.of((Object)req.detach(), (Object)req.getPub().gnnReqNo(), (Object)req.getPub().gnnTracingNo(), (Object)req.getPri().gnnExt().getDsz(), (Object)req.getPub().getMvc());
        req.getPub().setReqNo(null).setTracingNo(null).setMvc(null);
        req.getPri().gnnExt().setDsz(null);
        return rtn;
    }

    private Tuple.Pair<Boolean, Tuple.Quintuple<Ctx, String, String, String, String>> detach(Resp<?> resp) {
        return Tuple.of((Object)resp.detach(), this.detach((Req)resp.getData()));
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrCache * *..*.*(..))")
    private void pointcut() {
    }
}

