/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import com.fasterxml.jackson.databind.JavaType;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.persistence.entity.sql.Tenanted;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.crypto.MD5a;
import org.shaneking.ling.zero.crypto.SKC1;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.ling.zero.util.List0;
import org.shaneking.roc.jackson.JavaType3;
import org.shaneking.roc.persistence.CacheableEntities;
import org.shaneking.roc.persistence.dao.NumberedDao;
import org.shaneking.roc.persistence.dao.TenantedNumberedDao;
import org.shaneking.roc.persistence.entity.TenantedResourceAccessibleEntities;
import org.shaneking.roc.persistence.entity.sql.ChannelEntities;
import org.shaneking.roc.persistence.entity.sql.RrAuditLogEntities;
import org.shaneking.roc.persistence.entity.sql.TenantEntities;
import org.shaneking.roc.persistence.entity.sql.TenantReadTenantEntities;
import org.shaneking.roc.persistence.entity.sql.TenantUseTenantEntities;
import org.shaneking.roc.persistence.entity.sql.UserEntities;
import org.shaneking.roc.rr.Ctx;
import org.shaneking.roc.rr.Pri;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrCrypto;
import org.shaneking.roc.rr.service.RrAutoCreateUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.crypto", value={"enabled"}, matchIfMissing=true)
@Order(value=40000)
public class RrCryptoAspect {
    private static final Logger log = LoggerFactory.getLogger(RrCryptoAspect.class);
    public static final int ORDER = 40000;
    @Value(value="${sk.roc.rr.crypto.enabled:true}")
    private boolean enabled;
    @Autowired
    private Environment environment;
    @Autowired
    private NumberedDao numberedDao;
    @Autowired(required=false)
    private RrAutoCreateUserService autoCreateUserService;
    @Autowired(required=false)
    private TenantEntities tenantEntityClass;
    @Autowired
    private TenantedNumberedDao tenantedNumberedDao;
    @Autowired(required=false)
    private TenantReadTenantEntities tenantReadTenantEntities;
    @Autowired(required=false)
    private TenantUseTenantEntities tenantUseTenantEntities;
    @Autowired(required=false)
    private UserEntities userEntityClass;

    @Around(value="pointcut() && @annotation(rrCrypto)")
    public Object around(ProceedingJoinPoint pjp, RrCrypto rrCrypto) throws Throwable {
        Object rtn = null;
        boolean proceedBefore = false;
        boolean proceedAfter = false;
        if (this.enabled && this.tenantEntityClass != null && this.userEntityClass != null) {
            if (pjp.getArgs().length > rrCrypto.reqParamIdx() && pjp.getArgs()[rrCrypto.reqParamIdx()] instanceof Req) {
                Req req = (Req)pjp.getArgs()[rrCrypto.reqParamIdx()];
                try {
                    ChannelEntities channelEntity = req.gnnCtx().getChannel();
                    if (String0.Y.equalsIgnoreCase(channelEntity.getEncTf()) && (!String0.Y.equalsIgnoreCase(req.getPub().getEncoded()) || String0.isNullOrEmpty((String)req.getEnc()))) {
                        rtn = Resp.failed((String)"CHANNEL_ENTITIES__NEED_ENCODING", (String)req.getPub().getEncoded(), (Object)req);
                    } else {
                        String token = channelEntity.getEncTv();
                        if (!String0.isNullOrEmpty((String)token) && "PROP".equalsIgnoreCase(channelEntity.getEncTvt())) {
                            token = this.environment.getProperty(token, token);
                        }
                        if (String0.Y.equalsIgnoreCase(req.getPub().getEncoded()) && !String0.isNullOrEmpty((String)req.getEnc())) {
                            String enc = req.getEnc();
                            if (String0.Y.equalsIgnoreCase(channelEntity.getEncTf()) && String0.isNullOrEmpty((String)req.getPub().getMvc())) {
                                rtn = Resp.failed((String)"CHANNEL_ENTITIES__NEED_MVC", (String)channelEntity.getNo(), (Object)req);
                            } else if (!String0.isNullOrEmpty((String)req.getPub().getMvc())) {
                                if ("MD5".equalsIgnoreCase(channelEntity.getMvcTat())) {
                                    if (!req.getPub().getMvc().equalsIgnoreCase(MD5a.encrypt((String)enc))) {
                                        rtn = Resp.failed((String)"CHANNEL_ENTITIES__BAD_REQUEST", (String)OM3.lp((Object)req.getPub().getMvc(), (Object[])new Object[]{enc}), (Object)req);
                                    }
                                } else {
                                    rtn = Resp.failed((String)"CHANNEL_ENTITIES__ALGORITHM_UNSUPPORTED", (String)channelEntity.getMvcTat(), (Object)req);
                                }
                            }
                            if (rtn == null) {
                                JavaType[] javaTypes = JavaType3.resolveArgJavaTypes((ProceedingJoinPoint)pjp, (int)rrCrypto.reqParamIdx());
                                if ("SKC1".equalsIgnoreCase(channelEntity.getEncTat())) {
                                    enc = SKC1.decrypt((String)enc, (String)token);
                                } else {
                                    rtn = Resp.failed((String)"CHANNEL_ENTITIES__ALGORITHM_UNSUPPORTED", (String)channelEntity.getEncTat(), (Object)req);
                                }
                                req.setPri((Pri)OM3.readValue((String)enc, (JavaType)OM3.om().getTypeFactory().constructParametricType(Pri.class, javaTypes))).setEnc(null);
                            }
                        }
                        if (rtn == null) {
                            TenantEntities tenantEntity = (TenantEntities)this.numberedDao.oneByNo(this.tenantEntityClass.entityClass(), String0.nullOrEmptyTo((String)req.getPri().gnnExt().getTenantNo(), (String)req.getPub().getChannelNo()), true);
                            if (tenantEntity == null) {
                                rtn = Resp.failed((String)"NUMBERED__NOT_FOUND_BY_NUMBER", (String)String.valueOf(req.getPri().gnnExt().getTenantNo()), (Object)req);
                            } else {
                                req.gnnCtx().setTenant(tenantEntity);
                                if (req.gnnCtx().getAuditLog() != null) {
                                    req.gnnCtx().getAuditLog().setTenantId(tenantEntity.getId());
                                }
                                this.initAccessibleTenantCtx(req.gnnCtx());
                                UserEntities userEntity = (UserEntities)this.tenantedNumberedDao.oneByNo(this.userEntityClass.entityClass(), req.getPri().gnnExt().getUserNo(), tenantEntity.getId(), true);
                                if (userEntity == null && this.autoCreateUserService != null) {
                                    userEntity = this.autoCreateUserService.create(req);
                                }
                                if (userEntity == null) {
                                    rtn = Resp.failed((String)"ENTITIES__NOT_FOUND", (String)req.getPri().gnnExt().getUserNo(), (Object)req);
                                } else {
                                    Req respReq;
                                    Object respData;
                                    RrAuditLogEntities auditLogEntity;
                                    req.gnnCtx().setUser(userEntity);
                                    if (req.gnnCtx().getAuditLog() != null) {
                                        req.gnnCtx().getAuditLog().setReqUserId(userEntity.getId());
                                    }
                                    if ((auditLogEntity = req.gnnCtx().getAuditLog()) != null) {
                                        auditLogEntity.setReqJsonStr(OM3.writeValueAsString((Object)req));
                                    }
                                    this.initReadableTenantUserCtx(req.gnnCtx());
                                    proceedBefore = true;
                                    rtn = pjp.proceed();
                                    proceedAfter = true;
                                    if (auditLogEntity != null) {
                                        auditLogEntity.setRespJsonStr(OM3.writeValueAsString((Object)rtn));
                                    }
                                    if (rtn instanceof Resp && (respData = ((Resp)rtn).getData()) instanceof Req && (respReq = (Req)respData).getPri() != null && String0.Y.equalsIgnoreCase(respReq.getPub().getEncoded())) {
                                        String enc = OM3.writeValueAsString(respReq.getPri());
                                        if ("SKC1".equalsIgnoreCase(channelEntity.getEncTat())) {
                                            enc = SKC1.encrypt((String)enc, (String)token);
                                        }
                                        respReq.setEnc(enc).setPri(null);
                                        if (respReq.getPub() != null && !String0.isNullOrEmpty((String)respReq.getPub().getMvc())) {
                                            respReq.getPub().setMvc(MD5a.encrypt((String)enc));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    log.error(OM3.writeValueAsString((Object)req), throwable);
                    if (proceedBefore && !proceedAfter) {
                        throw throwable;
                    }
                    rtn = Resp.failed((String)"-1", (String)String.valueOf(throwable), (Object)req);
                }
            } else {
                log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrCrypto)}));
                rtn = pjp.proceed();
            }
        } else {
            rtn = pjp.proceed();
        }
        return rtn;
    }

    private void initAccessibleTenantCtx(Ctx ctx) {
        try {
            if (this.tenantUseTenantEntities != null) {
                ctx.getTutList().addAll(this.numberedDao.getCacheableDao().lst(this.tenantUseTenantEntities.entityClass(), (CacheableEntities)((TenantedResourceAccessibleEntities)this.tenantUseTenantEntities.entityClass().newInstance()).setToTenantId(ctx.gnaTenantId())));
            }
            if (this.tenantReadTenantEntities != null) {
                ctx.getTrtList().addAll(this.numberedDao.getCacheableDao().lst(this.tenantReadTenantEntities.entityClass(), (CacheableEntities)((TenantedResourceAccessibleEntities)this.tenantReadTenantEntities.entityClass().newInstance()).setToTenantId(ctx.gnaTenantId())));
            }
        }
        catch (Throwable throwable) {
            log.error(OM3.p((Object[])new Object[]{ctx}), throwable);
        }
    }

    private void initReadableTenantUserCtx(Ctx ctx) {
        try {
            UserEntities lstUser = (UserEntities)this.userEntityClass.entityClass().newInstance();
            lstUser.setNo(ctx.getUser().getNo());
            lstUser.forceWhereCondition("tenantId").resetVal(TenantedResourceAccessibleEntities.calc(ctx.getTrtList(), (String)this.userEntityClass.entityClass().getName(), (List)List0.newArrayList((Object[])new String[]{ctx.getUser().getTenantId()})));
            ctx.getRtuMap().putAll(this.numberedDao.getCacheableDao().lst(this.userEntityClass.entityClass(), (CacheableEntities)lstUser).stream().collect(Collectors.toMap(Tenanted::getTenantId, u -> u)));
        }
        catch (Throwable throwable) {
            log.error(OM3.p((Object[])new Object[]{ctx}), throwable);
        }
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrCrypto * *..*.*(..))")
    private void pointcut() {
    }
}

