/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import java.time.Duration;
import java.time.ZonedDateTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.ling.zero.time.ZDT0;
import org.shaneking.roc.persistence.entity.sql.ChannelEntities;
import org.shaneking.roc.rr.Req;
import org.shaneking.roc.rr.annotation.RrAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.dsz", value={"enabled"}, matchIfMissing=true)
@Order(value=60000)
public class RrDszAspect {
    private static final Logger log = LoggerFactory.getLogger(RrDszAspect.class);
    public static final int ORDER = 60000;
    @Value(value="${sk.roc.rr.dsz.enabled:true}")
    private boolean enabled;

    @Around(value="pointcut() && @annotation(rrAccess)")
    public Object around(ProceedingJoinPoint pjp, RrAccess rrAccess) throws Throwable {
        Object rtn = null;
        if (this.enabled) {
            if (pjp.getArgs().length > rrAccess.reqParamIdx() && pjp.getArgs()[rrAccess.reqParamIdx()] instanceof Req) {
                Req req = (Req)pjp.getArgs()[rrAccess.reqParamIdx()];
                ChannelEntities channelEntities = req.gnnCtx().getChannel();
                if (channelEntities != null && channelEntities.getDszSeconds() != null && channelEntities.getDszSeconds() > 0 && (String0.isNullOrEmpty((String)req.getPri().gnnExt().getDsz()) || Duration.between(ZDT0.on().dTSZ(req.getPri().gnnExt().getDsz()).getZonedDateTime(), ZonedDateTime.now()).getSeconds() > (long)channelEntities.getDszSeconds().intValue())) {
                    rtn = Resp.failed((String)"CHANNEL_ENTITIES__INVALID_TIMESTAMP", (String)req.getPri().gnnExt().getDsz(), (Object)req);
                } else {
                    Req respReq;
                    rtn = pjp.proceed();
                    if (rtn instanceof Resp && ((Resp)rtn).getData() instanceof Req && ((Req)((Resp)rtn).getData()).getPri() != null && !String0.isNullOrEmpty((String)(respReq = (Req)((Resp)rtn).getData()).getPri().gnnExt().getDsz())) {
                        respReq.getPri().gnnExt().setDsz(ZDT0.on().dTSZ());
                    }
                }
            } else {
                log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrAccess)}));
                rtn = pjp.proceed();
            }
        } else {
            rtn = pjp.proceed();
        }
        return rtn;
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrAccess * *..*.*(..))")
    private void pointcut() {
    }
}

