/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.rr.aspectj;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.ling.jackson.databind.OM3;
import org.shaneking.ling.rr.Resp;
import org.shaneking.ling.rr.RespException;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.text.MF0;
import org.shaneking.ling.zero.util.Map0;
import org.shaneking.ling.zero.util.concurrent.atomic.AtomicLong0;
import org.shaneking.roc.rr.annotation.RrLimiting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.rr.limiting", value={"enabled"}, matchIfMissing=true)
@Order(value=30000)
public class RrLimitingAspect {
    private static final Logger log = LoggerFactory.getLogger(RrLimitingAspect.class);
    public static final int ORDER = 30000;
    public static final String ERR_CODE__BUSY_NOW = "RR_LIMITING_ASPECT__BUSY_NOW";
    private final Map<String, AtomicLong> map = Map0.newConcurrentHashMap();
    @Value(value="${sk.roc.rr.limiting.enabled:true}")
    private boolean enabled;
    @Autowired
    private Environment environment;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Around(value="pointcut() && @annotation(rrLimiting)")
    public Object around(ProceedingJoinPoint pjp, RrLimiting rrLimiting) throws Throwable {
        Object rtn = null;
        if (!this.enabled) {
            return pjp.proceed();
        }
        if (!String0.isNullOrEmpty((String)rrLimiting.prop()) && rrLimiting.limit() > 0) {
            Integer limit = (Integer)this.environment.getProperty(rrLimiting.prop(), Integer.class, (Object)rrLimiting.limit());
            AtomicLong atomicLong = this.map.computeIfAbsent(rrLimiting.prop(), k -> new AtomicLong(0L));
            if (!AtomicLong0.tryIncreaseFailed((AtomicLong)atomicLong, (long)limit.intValue())) {
                log.warn(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{ERR_CODE__BUSY_NOW, pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrLimiting)}));
                throw new RespException(Resp.failed((String)ERR_CODE__BUSY_NOW, (String)ERR_CODE__BUSY_NOW));
            }
            try {
                rtn = pjp.proceed();
                return rtn;
            }
            catch (Throwable throwable) {
                log.error(pjp.getSignature().toLongString(), throwable);
                throw throwable;
            }
            finally {
                AtomicLong0.tryDecreaseFailed((AtomicLong)atomicLong);
            }
        }
        log.error(MF0.fmt((String)"{0} - {1} : {2}", (Object[])new Object[]{"ZERO_ANNOTATION__ANNOTATION_SETTING_ERROR", pjp.getSignature().toLongString(), OM3.writeValueAsString((Object)rrLimiting)}));
        return pjp.proceed();
    }

    @Pointcut(value="execution(@org.shaneking.roc.rr.annotation.RrLimiting * *..*.*(..))")
    private void pointcut() {
    }
}

