/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.zero.net;

import java.nio.file.Files;
import java.util.Map;
import java.util.PropertyResourceBundle;
import javax.annotation.PostConstruct;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.net.InetAddress0;
import org.shaneking.ling.zero.util.Map0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sk.roc.zero.net.address", ignoreInvalidFields=true)
public class InetAddress0Config {
    private static final Logger log = LoggerFactory.getLogger(InetAddress0Config.class);
    public static final String PREFIX = "sk.roc.zero.net.address";
    private boolean enabled = true;
    private String extHostsPath;
    private String extPropsPath;
    private Map<String, String> vhosts = Map0.newHashMap();

    @PostConstruct
    public void postConstruct() {
        if (this.isEnabled()) {
            Resource[] resources;
            PathMatchingResourcePatternResolver resolver;
            if (!String0.isNullOrEmpty((String)this.getExtHostsPath())) {
                resolver = new PathMatchingResourcePatternResolver();
                try {
                    for (Resource resource : resources = resolver.getResources(this.getExtHostsPath())) {
                        Files.lines(resource.getFile().toPath()).forEachOrdered(line -> {
                            String[] parts;
                            if (!String0.isNullOrEmpty((String)line) && !line.startsWith(String0.POUND) && (parts = line.split("\\s+")).length > 1) {
                                for (int i = 1; i < parts.length; ++i) {
                                    InetAddress0.putCustomHost((String)parts[i], (String)parts[0]);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.error(this.getExtPropsPath(), (Throwable)e);
                }
            }
            if (!String0.isNullOrEmpty((String)this.getExtPropsPath())) {
                resolver = new PathMatchingResourcePatternResolver();
                try {
                    for (Resource resource : resources = resolver.getResources(this.getExtPropsPath())) {
                        PropertyResourceBundle resourceBundle = new PropertyResourceBundle(resource.getInputStream());
                        resourceBundle.keySet().forEach(k -> InetAddress0.putCustomHost((String)k, (String)String0.nullToEmpty((String)resourceBundle.getString((String)k))));
                    }
                }
                catch (Exception e) {
                    log.error(this.getExtPropsPath(), (Throwable)e);
                }
            }
            this.getVhosts().forEach(InetAddress0::putCustomHost);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getExtHostsPath() {
        return this.extHostsPath;
    }

    public void setExtHostsPath(String extHostsPath) {
        this.extHostsPath = extHostsPath;
    }

    public String getExtPropsPath() {
        return this.extPropsPath;
    }

    public void setExtPropsPath(String extPropsPath) {
        this.extPropsPath = extPropsPath;
    }

    public Map<String, String> getVhosts() {
        return this.vhosts;
    }

    public void setVhosts(Map<String, String> vhosts) {
        this.vhosts = vhosts;
    }
}

