/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.zero.cache;

import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.shaneking.ling.zero.cache.ZeroCache;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.List0;
import org.shaneking.ling.zero.util.LruMap;
import org.shaneking.ling.zero.util.Map0;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public interface RocZeroCache
extends ZeroCache {
    default public String currentTransactionName() {
        return TransactionSynchronizationManager.getCurrentTransactionName();
    }

    default public Boolean del(boolean withoutTransactional, @NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (!withoutTransactional && this.inTransactional()) {
            ((Map)DEL_MAP.get()).computeIfAbsent(this.currentTransactionName(), k -> List0.newArrayList()).add(key);
        }
        LRU_MAP.remove((Object)key);
        return true;
    }

    default public Long hdel(boolean withoutTransactional, @NonNull String key, String ... fields) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        if (!withoutTransactional && this.inTransactional()) {
            ((Map)DEL_MAP2.get()).computeIfAbsent(this.currentTransactionName(), k -> Map0.newHashMap()).computeIfAbsent(key, k -> List0.newArrayList()).addAll(List0.newArrayList((Object[])fields));
        }
        long rtn = 0L;
        LruMap map = (LruMap)LRU_MAP2.get((Object)key);
        if (map != null) {
            for (String field : fields) {
                rtn += String0.isNullOrEmpty((String)((String)map.remove((Object)field))) ? 0L : 1L;
            }
        }
        return rtn;
    }

    default public void hmset(@NonNull String key, @NonNull Map<String, String> map) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        boolean contain = false;
        if (this.inTransactional()) {
            contain = ((Map)DEL_MAP.get()).computeIfAbsent(this.currentTransactionName(), k -> List0.newArrayList()).contains(key);
            List containList = ((Map)DEL_MAP2.get()).computeIfAbsent(this.currentTransactionName(), k -> Map0.newHashMap()).computeIfAbsent(key, k -> List0.newArrayList());
            if (!contain) {
                LruMap lruMap = (LruMap)LRU_MAP2.computeIfAbsent((Object)key, k -> new LruMap(1023));
                for (String field : map.keySet()) {
                    if (containList.contains(field)) continue;
                    lruMap.put((Object)field, (Object)map.get(field));
                }
            }
        } else {
            ((LruMap)LRU_MAP2.computeIfAbsent((Object)key, k -> new LruMap(1023))).putAll(map);
        }
    }

    default public void hset(@NonNull String key, @NonNull String field, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        boolean contain = false;
        if (this.inTransactional()) {
            boolean bl = contain = ((Map)DEL_MAP.get()).computeIfAbsent(this.currentTransactionName(), k -> List0.newArrayList()).contains(key) || ((Map)DEL_MAP2.get()).computeIfAbsent(this.currentTransactionName(), k -> Map0.newHashMap()).computeIfAbsent(key, k -> List0.newArrayList()).contains(field);
        }
        if (!contain) {
            ((LruMap)LRU_MAP2.computeIfAbsent((Object)key, k -> new LruMap(1023))).put((Object)field, (Object)value);
        }
    }

    default public boolean inTransactional() {
        return !String0.isNullOrEmpty((String)this.currentTransactionName()) && !TransactionSynchronizationManager.isCurrentTransactionReadOnly();
    }

    default public void set(@NonNull String key, @NonNull String value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        boolean contain = false;
        if (this.inTransactional()) {
            contain = ((Map)DEL_MAP.get()).computeIfAbsent(this.currentTransactionName(), k -> List0.newArrayList()).contains(key);
        }
        if (!contain) {
            LRU_MAP.put((Object)key, (Object)value);
        }
    }
}

