/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.zero.cache.aspectj;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.shaneking.roc.zero.cache.listener.CacheTransactionEventObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Aspect
@Component
@ConditionalOnProperty(prefix="sk.roc.zero.cache.transactional", value={"enabled"}, matchIfMissing=false)
@Order(value=500000)
public class CacheTransactionAspect {
    private static final Logger log = LoggerFactory.getLogger(CacheTransactionAspect.class);
    public static final int ORDER = 500000;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Around(value="pointcut() && @annotation(transactional)")
    public Object around(ProceedingJoinPoint pjp, Transactional transactional) throws Throwable {
        this.applicationEventPublisher.publishEvent((Object)new CacheTransactionEventObject().setReadOnly(transactional.readOnly()).setCurrentTransactionReadOnly(TransactionSynchronizationManager.isCurrentTransactionReadOnly()).setTransactionName(TransactionSynchronizationManager.getCurrentTransactionName()));
        return pjp.proceed();
    }

    @Pointcut(value="execution(@org.springframework.transaction.annotation.Transactional * *..*.*(..))")
    private void pointcut() {
    }
}

