/*
 * Decompiled with CFR 0.152.
 */
package org.shaneking.roc.zero.cache.listener;

import java.util.List;
import java.util.Map;
import org.shaneking.ling.zero.cache.ZeroCache;
import org.shaneking.ling.zero.lang.String0;
import org.shaneking.ling.zero.util.List0;
import org.shaneking.ling.zero.util.Map0;
import org.shaneking.roc.zero.cache.listener.CacheTransactionEventObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class CacheTransactionEventListener {
    @Autowired(required=false)
    private ZeroCache cache;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION)
    public void afterCompletion(PayloadApplicationEvent<CacheTransactionEventObject> event) {
        String transactionName = ((CacheTransactionEventObject)event.getPayload()).getTransactionName();
        if (!String0.isNullOrEmpty((String)transactionName)) {
            if (this.cache != null) {
                for (String string : ((Map)ZeroCache.DEL_MAP.get()).computeIfAbsent(transactionName, k -> List0.newArrayList())) {
                    this.cache.del(true, string);
                }
                for (Map.Entry entry : ((Map)ZeroCache.DEL_MAP2.get()).computeIfAbsent(transactionName, k -> Map0.newHashMap()).entrySet()) {
                    if (entry.getValue() == null) {
                        this.cache.del(true, (String)entry.getKey());
                        continue;
                    }
                    this.cache.hdel(true, (String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0]));
                }
            }
            ((Map)ZeroCache.DEL_MAP.get()).remove(transactionName);
            ((Map)ZeroCache.DEL_MAP2.get()).remove(transactionName);
        }
    }
}

