/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.encoder;

import com.sun.jna.Memory;
import com.sun.jna.ptr.IntByReference;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang3.Range;
import org.sheinbergon.aac.encoder.AACAudioOutput;
import org.sheinbergon.aac.encoder.WAVAudioInput;
import org.sheinbergon.aac.encoder.util.AACAudioEncoderException;
import org.sheinbergon.aac.encoder.util.AACEncodingChannelMode;
import org.sheinbergon.aac.encoder.util.AACEncodingProfile;
import org.sheinbergon.aac.jna.FdkAACLibFacade;
import org.sheinbergon.aac.jna.structure.AACEncBufDesc;
import org.sheinbergon.aac.jna.structure.AACEncInfo;
import org.sheinbergon.aac.jna.structure.AACEncoder;
import org.sheinbergon.aac.jna.util.AACEncParam;

@NotThreadSafe
public class AACAudioEncoder
implements AutoCloseable {
    private static final Range<Integer> BITRATE_RANGE = Range.between((Comparable)Integer.valueOf(64000), (Comparable)Integer.valueOf(640000));
    private static final Set<Integer> SAMPLE_RATES = Set.of(Integer.valueOf(8000), Integer.valueOf(11025), Integer.valueOf(12000), Integer.valueOf(16000), Integer.valueOf(22050), Integer.valueOf(24000), Integer.valueOf(32000), Integer.valueOf(44100), Integer.valueOf(48000));
    private static final int ADTS_TRANSMUX = 2;
    private static final int WAV_INPUT_CHANNEL_ORDER = 1;
    private static final int MAX_ENCODER_CHANNELS = 0;
    private static final int ENCODER_MODULES_MASK = 0;
    private static final int OUT_BUFFER_SIZE = 20480;
    private final AACEncoder encoder;
    private final int inputBufferSize;
    private final Memory inBuffer;
    private final Memory outBuffer;
    private final AACEncBufDesc inBufferDescriptor;
    private final AACEncBufDesc outBufferDescriptor;
    private boolean closed = false;

    private AACAudioEncoder(AACEncoder encoder, AACEncInfo info) {
        this.encoder = encoder;
        this.inputBufferSize = info.inputChannels * info.frameLength * 2;
        this.inBuffer = new Memory((long)this.inputBufferSize);
        this.outBuffer = new Memory(20480L);
        this.inBufferDescriptor = FdkAACLibFacade.inBufferDescriptor(this.inBuffer);
        this.outBufferDescriptor = FdkAACLibFacade.outBufferDescriptor(this.outBuffer);
        this.disableStructureSynchronization();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final AACAudioOutput encode(WAVAudioInput input) throws AACAudioEncoderException {
        this.verifyState();
        try {
            int read;
            AACAudioOutput.Accumulator accumlator = AACAudioOutput.accumulator();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(input.data());
            byte[] buffer = new byte[this.inputBufferSize()];
            while ((read = inputStream.read(buffer)) != -1) {
                this.populateInputBuffer(buffer, read);
                byte[] encoded = FdkAACLibFacade.encode(this.encoder, this.inBufferDescriptor, this.outBufferDescriptor, read).orElseThrow(() -> new IllegalStateException("No encoded audio data returned"));
                accumlator.accumulate(encoded);
            }
            return accumlator.done();
        }
        catch (IOException | RuntimeException x) {
            throw new AACAudioEncoderException("Could not encode WAV audio to AAC audio", x);
        }
    }

    public final AACAudioOutput conclude() throws AACAudioEncoderException {
        this.verifyState();
        try {
            Optional<byte[]> optional;
            this.inBufferDescriptor.clear();
            AACAudioOutput.Accumulator accumlator = AACAudioOutput.accumulator();
            while ((optional = FdkAACLibFacade.encode(this.encoder, this.inBufferDescriptor, this.outBufferDescriptor, -1)).isPresent()) {
                accumlator.accumulate(optional.get());
            }
            AACAudioOutput aACAudioOutput = accumlator.done();
            return aACAudioOutput;
        }
        catch (RuntimeException x) {
            throw new AACAudioEncoderException("Could not conclude WAV audio to AAC audio", x);
        }
        finally {
            this.close();
        }
    }

    private void populateInputBuffer(byte[] buffer, int size) {
        this.inBuffer.write(0L, buffer, 0, size);
        if (size != this.inputBufferSize) {
            this.inBufferDescriptor.bufSizes = new IntByReference(size);
            this.inBufferDescriptor.writeField("bufSizes");
        }
    }

    private void disableStructureSynchronization() {
        this.encoder.write();
        this.encoder.setAutoSynch(false);
        this.inBufferDescriptor.write();
        this.inBufferDescriptor.setAutoSynch(false);
        this.outBufferDescriptor.write();
        this.outBufferDescriptor.setAutoSynch(false);
    }

    private void verifyState() {
        if (this.closed) {
            throw new AACAudioEncoderException("Encoder instance already closed");
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            FdkAACLibFacade.closeEncoder(this.encoder);
            this.closed = true;
        }
    }

    public int inputBufferSize() {
        return this.inputBufferSize;
    }

    public static class Builder {
        private static final float SAMPLES_TO_BIT_RATE_FACTOR = 1.5f;
        private boolean afterBurner = true;
        private AACEncodingProfile profile = AACEncodingProfile.AAC_LC;
        private int channels = 2;
        private int bitRate = 64000;
        private int sampleRate = 44100;

        private void setEncoderParams(AACEncoder encoder) {
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_AFTERBURNER, this.afterBurner ? 1 : 0);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_SAMPLERATE, this.sampleRate);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_BITRATE, this.bitRate);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_TRANSMUX, 2);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_AOT, this.profile.getAot());
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_CHANNELORDER, 1);
            FdkAACLibFacade.setEncoderParam(encoder, AACEncParam.AACENC_CHANNELMODE, AACEncodingChannelMode.valueOf(this.channels).getMode());
        }

        private void adaptBitRate() {
            float minimalBitRate = (float)(this.channels * this.sampleRate) / 1.5f;
            this.bitRate = minimalBitRate > (float)this.bitRate ? (int)minimalBitRate : this.bitRate;
        }

        public AACAudioEncoder build() {
            this.adaptBitRate();
            if (!SAMPLE_RATES.contains(this.sampleRate)) {
                throw new AACAudioEncoderException("sampleRate", this.sampleRate);
            }
            if (!BITRATE_RANGE.contains((Object)this.bitRate)) {
                throw new AACAudioEncoderException("bitRate", this.bitRate);
            }
            if (AACEncodingChannelMode.valueOf(this.channels) == AACEncodingChannelMode.MODE_INVALID) {
                throw new AACAudioEncoderException("channels", this.channels);
            }
            AACEncoder encoder = FdkAACLibFacade.openEncoder(0, 0);
            this.setEncoderParams(encoder);
            FdkAACLibFacade.initEncoder(encoder);
            AACEncInfo info = FdkAACLibFacade.getEncoderInfo(encoder);
            return new AACAudioEncoder(encoder, info);
        }

        public Builder afterBurner(boolean afterBurner) {
            this.afterBurner = afterBurner;
            return this;
        }

        public Builder profile(AACEncodingProfile profile) {
            this.profile = profile;
            return this;
        }

        public Builder channels(int channels) {
            this.channels = channels;
            return this;
        }

        public Builder bitRate(int bitRate) {
            this.bitRate = bitRate;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        private Builder() {
        }
    }
}

