/*
 * Decompiled with CFR 0.152.
 */
package org.sheinbergon.aac.sound;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.AudioFileWriter;
import org.sheinbergon.aac.encoder.AACAudioEncoder;
import org.sheinbergon.aac.encoder.AACAudioOutput;
import org.sheinbergon.aac.encoder.WAVAudioInput;
import org.sheinbergon.aac.encoder.util.AACEncodingProfile;
import org.sheinbergon.aac.encoder.util.WAVAudioSupport;
import org.sheinbergon.aac.sound.AACFileTypes;

public final class AACFileWriter
extends AudioFileWriter {
    private static final int OUTPUT_BUFFER_SIZE = 16384;
    private static final int INPUT_BUFFER_MULTIPLIER = 16;
    private static final Map<AudioFileFormat.Type, AACEncodingProfile> FILE_TYPES_TO_ENCODING_PROFILES = Map.of(AACFileTypes.AAC_LC, AACEncodingProfile.AAC_LC, AACFileTypes.AAC_HE, AACEncodingProfile.HE_AAC, AACFileTypes.AAC_HE_V2, AACEncodingProfile.HE_AAC_V2);

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes() {
        return (AudioFileFormat.Type[])Stream.of(AACFileTypes.AAC_LC, AACFileTypes.AAC_HE, AACFileTypes.AAC_HE_V2).toArray(AudioFileFormat.Type[]::new);
    }

    @Override
    public AudioFileFormat.Type[] getAudioFileTypes(AudioInputStream stream) {
        AudioFormat format = stream.getFormat();
        if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && format.getSampleSizeInBits() == 16 && WAVAudioSupport.SUPPORTED_CHANNELS_RANGE.contains((Object)format.getChannels()) && !format.isBigEndian()) {
            return this.getAudioFileTypes();
        }
        return new AudioFileFormat.Type[0];
    }

    static AACEncodingProfile profileByType(AudioFileFormat.Type type) {
        return Optional.ofNullable(FILE_TYPES_TO_ENCODING_PROFILES.get(type)).orElseThrow(() -> new IllegalArgumentException("File type " + type + " is not yet supported"));
    }

    private static AACAudioEncoder encoder(AudioFormat format, AudioFileFormat.Type type) {
        return AACAudioEncoder.builder().afterBurner(true).channels(format.getChannels()).sampleRate((int)format.getSampleRate()).profile(AACFileWriter.profileByType(type)).build();
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(fileType);
        Objects.requireNonNull(out);
        if (!this.isFileTypeSupported(fileType, stream)) {
            throw new IllegalArgumentException("File type " + fileType + " is not supported.");
        }
        return this.encodeAndWrite(stream, fileType, out);
    }

    @Override
    public int write(AudioInputStream stream, AudioFileFormat.Type fileType, File out) throws IOException {
        BufferedOutputStream bufferedOutputStream;
        Objects.requireNonNull(stream);
        Objects.requireNonNull(fileType);
        Objects.requireNonNull(out);
        try (BufferedOutputStream bufferedOutputStream2 = bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(out), 16384);){
            int n = this.write(stream, fileType, bufferedOutputStream);
            return n;
        }
    }

    private int readBufferSize(AudioFormat format, AACAudioEncoder encoder) {
        return encoder.inputBufferSize() * 16;
    }

    private int encodeAndWrite(AudioInputStream input, AudioFileFormat.Type type, OutputStream output) throws IOException {
        AACAudioEncoder encoder;
        boolean concluded = false;
        int encoded = 0;
        AudioFormat format = input.getFormat();
        try (AACAudioEncoder aACAudioEncoder = encoder = AACFileWriter.encoder(format, type);){
            int readBufferSize = this.readBufferSize(format, encoder);
            byte[] readBuffer = new byte[readBufferSize];
            while (!concluded) {
                AACAudioOutput audioOutput;
                int read = input.read(readBuffer);
                if (read == -1) {
                    audioOutput = encoder.conclude();
                    concluded = true;
                } else {
                    WAVAudioInput audioInput = WAVAudioInput.pcms16le(readBuffer, read);
                    audioOutput = encoder.encode(audioInput);
                }
                encoded += audioOutput.length();
                output.write(audioOutput.data());
            }
        }
        return encoded;
    }
}

